/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.TravisURLHelper;
import com.xebialabs.agatha.crawlers.travis.components.TravisResponseFetcher;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobsMessage;
import com.xebialabs.agatha.crawlers.travis.models.Job;
import com.xebialabs.agatha.crawlers.travis.models.dtos.JobsResponse;
import com.xebialabs.agatha.crawlers.travis.services.TravisBaseCrawl;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravisBuildJobsCrawl
extends TravisBaseCrawl<TravisBuildJobsMessage, JobsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(TravisBuildJobsCrawl.class);

    public TravisBuildJobsCrawl(TravisCrawler crawler, TravisBuildJobsMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new TravisResponseFetcher(crawler));
    }

    @Override
    protected CrawledDataWrappedResponse<JobsResponse> processTravisMessage() throws CrawlerWorkException {
        logger.debug("Process TravisBuildJobsMessage for repo - {}, buildid - {} ", (Object)((TravisBuildJobsMessage)this.message).getRepoName(), (Object)((TravisBuildJobsMessage)this.message).getBuildId());
        CrawledDataWrappedResponse response = this.getResponseFetcher().fetchEntity(JobsResponse.class, TravisURLHelper.jobsUrl((TravisBuildJobsMessage)this.message));
        this.handleResponse((JobsResponse)((Object)response.getEntity()));
        return response;
    }

    private void handleResponse(JobsResponse response) throws CrawlerWorkException {
        List<Job> jobs = response.getJobs();
        logger.debug("Found {} jobs in build - {}, repo - {}", new Object[]{jobs.size(), ((TravisBuildJobsMessage)this.message).getBuildId(), ((TravisBuildJobsMessage)this.message).getRepoName()});
        List<Job> filteredJobs = this.filterBuilds(jobs);
        logger.debug("{} jobs after applying filter", (Object)jobs.size());
        for (Job job : filteredJobs) {
            this.handleJob(job);
        }
    }

    private void handleJob(Job job) throws CrawlerWorkException {
        try {
            TravisBuildJobMessage dm = this.populateJobAttributes(((TravisCrawler)this.crawler).generateNewMessage(TravisBuildJobMessage.class, this.message), job);
            ((TravisCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(TravisBuildJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private TravisBuildJobMessage populateJobAttributes(TravisBuildJobMessage travisBuildJobMessage, Job job) {
        travisBuildJobMessage.setJobId(job.getId()).setSelfUrl(job.getSelfUrl());
        return travisBuildJobMessage;
    }
}

