/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.travis.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.agatha.crawlers.travis.TravisCrawler;
import com.xebialabs.agatha.crawlers.travis.TravisURLHelper;
import com.xebialabs.agatha.crawlers.travis.components.TravisResponseFetcher;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildJobsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisBuildsMessage;
import com.xebialabs.agatha.crawlers.travis.messages.TravisJobMessage;
import com.xebialabs.agatha.crawlers.travis.models.Build;
import com.xebialabs.agatha.crawlers.travis.models.dtos.BuildsResponse;
import com.xebialabs.agatha.crawlers.travis.services.TravisBaseCrawl;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravisBuildsCrawl
extends TravisBaseCrawl<TravisBuildsMessage, BuildsResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(TravisBuildsCrawl.class);

    public TravisBuildsCrawl(TravisCrawler crawler, TravisBuildsMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage, new TravisResponseFetcher(crawler));
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            TravisJobMessage dm = ((TravisCrawler)this.crawler).generateNewMessage(TravisBuildsMessage.class, this.message).setLimit(((TravisBuildsMessage)this.message).getLimit()).setUrl(this.nextURL);
            return this.createDataMessage(TravisBuildsMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<BuildsResponse> processTravisMessage() throws CrawlerWorkException {
        logger.debug("Process TravisBuildsMessage for repo - {}", (Object)((TravisBuildsMessage)this.message).getRepoName());
        CrawledDataWrappedResponse response = this.getResponseFetcher().fetchEntity(BuildsResponse.class, TravisURLHelper.buildsUrl((TravisBuildsMessage)this.message));
        this.handleResponse((BuildsResponse)((Object)response.getEntity()));
        return response;
    }

    private void handleResponse(BuildsResponse response) throws CrawlerWorkException {
        List<Build> builds = response.getBuilds();
        logger.debug("Found {} builds in repo {}", (Object)builds.size(), (Object)((TravisBuildsMessage)this.message).getRepoName());
        List<Build> filteredBuilds = this.filterBuilds(builds);
        logger.debug("{} builds after applying filter", (Object)builds.size());
        for (Build build : filteredBuilds) {
            this.handleBuilds(build);
        }
    }

    private void handleBuilds(Build build) throws CrawlerWorkException {
        this.sendMessage(build, TravisBuildMessage.class);
        this.sendMessage(build, TravisBuildJobsMessage.class);
    }

    private <C extends TravisBuildMessage> void sendMessage(Build build, Class<C> clazz) throws CrawlerWorkException {
        try {
            TravisBuildMessage dm = this.populateBuildAttributes((TravisBuildMessage)((Object)((TravisCrawler)this.crawler).generateNewMessage(clazz, this.message)), build);
            ((TravisCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(clazz.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private <C extends TravisBuildMessage> C populateBuildAttributes(C travisBuildMessage, Build build) {
        travisBuildMessage.setBuildId(build.getId()).setSelfUrl(build.getSelfUrl());
        return travisBuildMessage;
    }
}

