/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.logging.LogEntrySourceLocation;
import com.xebialabs.agatha.logging.StackdriverLoggingEvent;
import com.xebialabs.agatha.logging.StackdriverServiceContext;
import com.xebialabs.agatha.logging.StackdriverTimestamp;
import java.util.Map;

@JsonIgnoreType
public class StackdriverLogbackLayout
extends PatternLayout {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private String serviceName;
    private String serviceVersion;

    public StackdriverLogbackLayout() {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        String formattedMessage = super.doLayout(event);
        return this.doLayoutInternal(formattedMessage, event);
    }

    private String doLayoutInternal(String formattedMessage, ILoggingEvent event) {
        StackdriverLoggingEvent gcpLogEvent = new StackdriverLoggingEvent(formattedMessage, StackdriverTimestamp.fromLogbackTimestamp(event.getTimeStamp()), StackdriverLogbackLayout.mapLogbackLevelToSeverity(event.getLevel()), event.getThreadName(), StackdriverLogbackLayout.fromLogbackEvent(event), this.getServiceContext());
        try {
            return objectMapper.writeValueAsString(gcpLogEvent) + "\n";
        }
        catch (JsonProcessingException e) {
            return "Unexpected JSON processing error: " + e.getMessage();
        }
    }

    private StackdriverServiceContext getServiceContext() {
        if (this.serviceName == null && this.serviceVersion == null) {
            return null;
        }
        return new StackdriverServiceContext(this.serviceName, this.serviceVersion);
    }

    private static LogEntrySourceLocation fromLogbackEvent(ILoggingEvent event) {
        StackTraceElement lastStackTraceElement = event.getCallerData()[0];
        return new LogEntrySourceLocation(lastStackTraceElement.getFileName(), Integer.toString(lastStackTraceElement.getLineNumber()), lastStackTraceElement.getClassName() + "." + lastStackTraceElement.getMethodName());
    }

    private static String mapLogbackLevelToSeverity(Level level) {
        switch (level.toInt()) {
            case 5000: {
                return "TRACE";
            }
            case 10000: {
                return "DEBUG";
            }
            case 20000: {
                return "INFO";
            }
            case 30000: {
                return "WARN";
            }
            case 40000: {
                return "ERROR";
            }
        }
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    @Override
    public Map<String, String> getDefaultConverterMap() {
        return PatternLayout.defaultConverterMap;
    }
}

