/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.utils;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.exception.CiValidationException;
import com.xebialabs.ascode.service.AsCodeResponse;
import com.xebialabs.ascode.utils.TypeSugar$;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xltype.serialization.CiReference;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    private boolean isDefaultValueOrEmpty(ConfigurationItem ci, PropertyDescriptor descriptor) {
        Object value = descriptor.get(ci);
        Object object = descriptor.getDefaultValue();
        return value == null || BoxesRunTime.equals((Object)value, (Object)object);
    }

    public String getCiTitle(ConfigurationItem ci) {
        String string;
        PropertyDescriptor propertyDescriptor = ci.getType().getDescriptor().getPropertyDescriptor("title");
        if (propertyDescriptor == null) {
            String string2;
            ConfigurationItem configurationItem = ci;
            if (configurationItem instanceof ValueProviderConfiguration) {
                string2 = ((ValueProviderConfiguration)configurationItem).getVariable().getKey();
            } else if (configurationItem instanceof Variable) {
                string2 = ((Variable)configurationItem).getKey();
            } else {
                throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The referenced ci with type [", "] is not supported yet."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configurationItem.getType().toString()})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            string = string2;
        } else if (ci instanceof Dashboard) {
            None$ dashTitle;
            None$ title = this.isDefaultValueOrEmpty(ci, propertyDescriptor) ? None$.MODULE$ : new Some((Object)((String)propertyDescriptor.get(ci)));
            PropertyDescriptor parentIdDescriptor = ci.getType().getDescriptor().getPropertyDescriptor("parentId");
            Object object = dashTitle = this.isDefaultValueOrEmpty(ci, parentIdDescriptor) ? None$.MODULE$ : new Some((Object)((String)parentIdDescriptor.get(ci)));
            if (title.isDefined() && dashTitle.isDefined()) {
                throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The ci with type [", "] have the fields [title, parentId] filled, please just fill one field."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ci.getType().toString()})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            if (title.isEmpty() && dashTitle.isEmpty()) {
                throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The ci with type [", "] have the fields [title, parentId] empty."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ci.getType().toString()})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            string = (String)title.getOrElse(() -> Utils$.$anonfun$getCiTitle$1((Option)dashTitle));
        } else {
            Object title = propertyDescriptor.get(ci);
            if (title == null) {
                throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The ci with type [", "] have the field [title] empty."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ci.getType().toString()})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            string = (String)title;
        }
        return string;
    }

    public String getCiPathAndSubstitute(ConfigurationItem ci) {
        Option propertyDescriptor = Option$.MODULE$.apply((Object)ci.getType().getDescriptor().getPropertyDescriptor("title"));
        return (String)propertyDescriptor.map((Function1 & Serializable & scala.Serializable)descriptor -> {
            void var3_3;
            Option ciTitle = Option$.MODULE$.apply((Object)((String)descriptor.get(ci)));
            String relativePath = (String)MODULE$.getFolderPathFromCiPath((String)ciTitle.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            descriptor.set(ci, (Object)Ids.getName((String)((String)ciTitle.orNull(Predef$.MODULE$.$conforms()))));
            return var3_3;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> getFolderPathFromCiPath(String ciPath) {
        String[] splittedPath = new StringOps(Predef$.MODULE$.augmentString(ciPath)).stripMargin('/').split("/");
        return splittedPath.length > 1 ? new Some((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splittedPath)).slice(0, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splittedPath)).size() - 1))).mkString("/")) : None$.MODULE$;
    }

    public void checkIfTriggerVariablesAreCorrect(List<Variable> releaseVariables, List<Variable> triggerVariables, String triggerTitle) {
        List nullValueVariables = (List)triggerVariables.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkIfTriggerVariablesAreCorrect$1(x$1)));
        if (nullValueVariables.nonEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The variables [", "] that were set in the trigger [", "] got no value setup."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)nullValueVariables.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getKey(), List$.MODULE$.canBuildFrom())).mkString(", "), triggerTitle})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        List missingVariables = (List)triggerVariables.filterNot((Function1 & Serializable & scala.Serializable)trigVar -> BoxesRunTime.boxToBoolean((boolean)releaseVariables.exists((Function1 & Serializable & scala.Serializable)relVal -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkIfTriggerVariablesAreCorrect$4(trigVar, relVal)))));
        if (missingVariables.nonEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The variables [", "] that were set in the trigger [", "] are incorrect."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)missingVariables.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getKey(), List$.MODULE$.canBuildFrom())).mkString(", "), triggerTitle})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public <T extends ConfigurationItem> List<T> filterCisByFolder(List<T> cis, String folderId) {
        return (List)cis.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$filterCisByFolder$1(folderId, x)));
    }

    public <T extends ConfigurationItem> String filterCisByFolder$default$2() {
        return "/";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStringEmpty(Object value) {
        if (!(value instanceof String)) return false;
        Object object = value;
        String string = "";
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    public boolean isRequiredReferenceAndDontHaveValue(List<CiReference> referencesWithType, PropertyDescriptor field) {
        return !referencesWithType.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$isRequiredReferenceAndDontHaveValue$1(field, x$4)));
    }

    public <T extends ConfigurationItem> void checkRequiredCiFields(T ci, List<CiReference> references) {
        List list;
        Type ciType = ci.getType();
        Descriptor descriptor = ciType.getDescriptor();
        List requiredFieldsWithoutReferences = ((TraversableOnce)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(descriptor.getPropertyDescriptors()).filter((Function1 & Serializable & scala.Serializable)property -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkRequiredCiFields$1(property)))).toList();
        List requiredFieldsWithReferences = ((TraversableOnce)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(descriptor.getPropertyDescriptors()).filter((Function1 & Serializable & scala.Serializable)property -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkRequiredCiFields$2(property)))).toList();
        List referencesWithType = (List)references.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkRequiredCiFields$3(ciType, x$5)));
        List requiredFieldsWithoutReferencesEmpty = (List)requiredFieldsWithoutReferences.withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkRequiredCiFields$4(ci, field))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), List$.MODULE$.canBuildFrom());
        List requiredFieldsWithReferencesEmpty = (List)requiredFieldsWithReferences.withFilter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isRequiredReferenceAndDontHaveValue((List<CiReference>)referencesWithType, field))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getName(), List$.MODULE$.canBuildFrom());
        List allMissingFields = requiredFieldsWithReferencesEmpty.$colon$colon$colon(list = requiredFieldsWithoutReferencesEmpty);
        if (allMissingFields.nonEmpty()) {
            throw new CiValidationException((List)allMissingFields.map((Function1 & Serializable & scala.Serializable)field -> new AsCodeResponse.CiValidationError(ci.getId(), field, "The field is required but was not filled"), List$.MODULE$.canBuildFrom()));
        }
    }

    public <T extends ConfigurationItem> List<CiReference> checkRequiredCiFields$default$2() {
        return List$.MODULE$.empty();
    }

    public <T extends ConfigurationItem> boolean isTypeAPythonScript(T ci) {
        return this.isTypeAPythonScript(ci.getType());
    }

    public boolean isTypeAPythonScript(String ciType) {
        return this.isTypeAPythonScript(TypeSugar$.MODULE$.typeOf(ciType));
    }

    public boolean isTypeAPythonScript(Type ciType) {
        return PythonScriptDefinition.isScriptDefinition((Type)ciType);
    }

    public boolean beginsWithCaret(String string) {
        return string.startsWith("^");
    }

    public ListMap<Option<String>, List<ConfigurationItem>> joinMapOfLists(ListMap<Option<String>, List<ConfigurationItem>> map1, ListMap<Option<String>, List<ConfigurationItem>> map2) {
        return map1.$plus$plus((GenTraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option key = (Option)tuple2._1();
            List value = (List)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), map1.get((Object)key).map((Function1 & Serializable & scala.Serializable)x$9 -> (List)x$9.$plus$plus((GenTraversableOnce)value, List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> value));
            return tuple22;
        }, ListMap$.MODULE$.canBuildFrom()));
    }

    public String buildFolderPath(String parent, String title) {
        String string = parent;
        String string2 = "/";
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parent, title})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parent, "/", title}));
    }

    public String buildDashboardIdFromTemplateId(String templateId) {
        return templateId + "/" + "summary";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTypeOrSubtype(Type ciType, String comparativeType) {
        if (TypeSugar$.MODULE$.typeOf(comparativeType).isSubTypeOf(ciType)) return true;
        Type type = TypeSugar$.MODULE$.typeOf(comparativeType);
        Type type2 = ciType;
        if (type != null) {
            if (!type.equals(type2)) return false;
            return true;
        }
        if (type2 == null) return true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$getCiTitle$1(Option dashTitle$1) {
        return (String)dashTitle$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$checkIfTriggerVariablesAreCorrect$1(Variable x$1) {
        return x$1.getValue() == null;
    }

    public static final /* synthetic */ boolean $anonfun$checkIfTriggerVariablesAreCorrect$4(Variable trigVar$1, Variable relVal) {
        String string = relVal.getKey();
        String string2 = trigVar$1.getKey();
        return !(string != null ? !string.equals(string2) : string2 != null) && relVal.getShowOnReleaseStart();
    }

    public static final /* synthetic */ boolean $anonfun$filterCisByFolder$1(String folderId$1, ConfigurationItem x) {
        String string = folderId$1;
        String string2 = "/";
        return (string == null ? string2 != null : !string.equals(string2)) ? x.getId().startsWith(folderId$1) : Ids.isInRootFolder((String)x.getId());
    }

    public static final /* synthetic */ boolean $anonfun$isRequiredReferenceAndDontHaveValue$1(PropertyDescriptor field$1, CiReference x$4) {
        PropertyDescriptor propertyDescriptor = x$4.getProperty();
        PropertyDescriptor propertyDescriptor2 = field$1;
        return !(propertyDescriptor != null ? !propertyDescriptor.equals(propertyDescriptor2) : propertyDescriptor2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkRequiredCiFields$1(PropertyDescriptor property) {
        return property.isRequired() && property.getReferencedType() == null;
    }

    public static final /* synthetic */ boolean $anonfun$checkRequiredCiFields$2(PropertyDescriptor property) {
        return property.isRequired() && property.getReferencedType() != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkRequiredCiFields$3(Type ciType$1, CiReference x$5) {
        Type type = x$5.getCi().getType();
        Type type2 = ciType$1;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkRequiredCiFields$4(ConfigurationItem ci$2, PropertyDescriptor field) {
        return field.get(ci$2) == null || MODULE$.isStringEmpty(field.get(ci$2));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

