class DateTimePicker {
    constructor(selector) {
        this.selector = selector;
    }

    setDate({day, month, year}) {
        this.openDatePicker();
        if (year) {
            this.switchToMonth();
            this.switchToYear();
            element(By.$(`.datepicker .year:contains('${year}')`)).click();
        }
        if (month) {
            if (!year) {
                this.switchToMonth();
            }
            element(By.$(`.datepicker .month:eq(${month - 1})`)).click();
        }

        return element.all(By.$(`.datepicker .day:not(.old):not(.new):contains('${day}')`)).first().click();
    }

    setTime({hour, minute}, closeFn) {
        return browser.executeScript(function () {
            let $injector = angular.element('body').injector();
            let DateFormatDetector = $injector.get('DateFormatDetector');
            return DateFormatDetector.isAmPmVisible();
        }).then(isAmPmVisible => {
                element(By.$(`${this.selector} .time`)).click();
                let hourInput = element(By.css(".bootstrap-timepicker-widget .bootstrap-timepicker-hour"));
                let minuteInput = element(By.css(".bootstrap-timepicker-widget .bootstrap-timepicker-minute"));
                let meridianInput = element(By.css(".bootstrap-timepicker-widget .bootstrap-timepicker-meridian"));
                if (isAmPmVisible) {
                    if (hour > 12) {
                        var meridian = 'PM';
                        hour = hour - 12;
                    } else if (hour == 12) {
                        var meridian = 'PM';
                    } else if (hour == 0) {
                        hour = 12;
                        var meridian = 'AM';
                    } else {
                        var meridian = 'AM';
                    }
                    meridianInput.click();
                    meridianInput.clear();
                    meridianInput.sendKeys(meridian);
                }
                if (hour !== null) {
                    hourInput.click();
                    hourInput.clear();
                    hourInput.sendKeys(hour);
                }
                if (minute !== null) {
                    minuteInput.click();
                    minuteInput.clear();
                    minuteInput.sendKeys(minute);
                }
                return closeFn ? closeFn() : hourInput.sendKeys(protractor.Key.ESCAPE);
            }
        );
    }

    openDatePicker() {
        return element(By.$(`${this.selector} .date`)).click();
    }

    switchToMonth() {
        return element(By.css(".datepicker-days .datepicker-switch")).click();
    }

    switchToYear() {
        return element(By.css(".datepicker-months .datepicker-switch")).click();
    }

    setDateTime({day, month, year, hour, minute}) {
        if (day) {
            this.setDate({day, month, year});
        }
        if (hour || minute) {
            return this.setTime({hour, minute});
        }
    }

    removeDate() {
        return element(By.$(`${this.selector} .remove`)).click();
    }

    expectDateNotDeletable() {
        expect(element(By.$(`${this.selector} .remove`)).isPresent()).toBe(false);
    }

    expectDateToBe(format, date) {
        return Dates.expectInputContainingDate(By.$(`${this.selector} .date input`), format, date);
    }

    expectDateToBeInferred() {
        expect(element(By.$(`${this.selector} input.light-text`))).toBeDisplayed();
        return this;
    }

    expectTimeToBe(format, date) {
        return Dates.expectInputContainingDate(By.$(`${this.selector} .time input`), format, date);
    }

    expectNoDate() {
        expect(element(By.$(`${this.selector} .date-placeholder`))).toBeDisplayed();
    }
}


global.DateTimePicker = DateTimePicker;
