class RestartPhaseModal {
    constructor() {
        expect(browser.isElementPresent(By.id('modal'))).toBe(true);
    }

    continue() {
        element(By.css('.modal .continue')).click();
        return new RestartPhaseModal();
    }

    resumeNow() {
        element(By.css('.modal .resume-now')).click();
        return this;
    }

    resumeLater() {
        element(By.css('.modal .resume-later')).click();
        return this;
    }

    setPasswordVariable(key, value) {
        let editor = new InlineEditor(`.modal div[inline-password-editor][name='${key}']`);
        editor.set(value);
        return this;
    }

    setTextVariable(key, value) {
        let editor = new InlineEditor(`.modal div[inline-text-editor][name='${key}']`);
        editor.set(value);
        return this;
    }
}

global.RestartPhaseModal = RestartPhaseModal;
