class MainMenuPage {
    constructor() {
        Browser.waitFor('#main-menu');
    }

    expectMenu(title) {
        expect(element(By.$(`.menu-level-0 .menu-element:contains('${title}')`))).toBeDisplayed();
        return this;
    }

    clickMenu(title) {
        element(By.$(`.menu-level-0 .menu-element:contains('${title}')`)).click();
        return this;
    }

    expectSubMenu(title) {
        expect(element(By.$(`.nav-in-header li:contains('${title}')`))).toBeDisplayed();
        return this;
    }

    selectSubMenu(title) {
        element(By.$(`.nav-in-header li:contains('${title}')`)).click();
        return this;
    }
}

global.MainMenuPage = MainMenuPage;
