const getValue = (classIdentifier) => {
    return element.all(by.css(`.rz-bubble.${classIdentifier}-label`)).then((minLabel) => minLabel[0].getText());
};

const setPointerValue = (elem, value, isIncrease) => {
    elem.click();
    for (let i = 0; i < value; i++) {
        const key = isIncrease ? protractor.Key.RIGHT : protractor.Key.LEFT;
        elem.sendKeys(key);
    }
};

const setValue = (identifier, newValue) => {
    getValue(identifier).then((value) => {
        const initialDiff = newValue - parseInt(value);
        element.all(by.css(`.rz-pointer-${identifier}`)).then((elem) => {
            setPointerValue(elem[0], Math.abs(initialDiff), initialDiff > 0);
            checkValue(identifier, newValue);
        });
    });
};

const checkValue = (identifier, value) => {
    expect(getValue(identifier)).toEqual(value + '');
};

class RisksPage {
    constructor() {
        Browser.waitFor('#risk-settings');
        this.min = 0;
        this.max = 100;
    }

    setInitialValues() {
        setValue('min', 10);
        setValue('max', 50);
        return this;
    }

    getInitialValues() {
        getValue('min').then((va) => (this.min = parseInt(va)));

        getValue('max').then((va) => (this.max = parseInt(va)));
        return this;
    }

    startEditGlobalRiskThreshold() {
        $('a[data-test="editThreshold"]').click();
        return this;
    }

    changeValuesAndSave(minValue, maxValue) {
        setValue('min', minValue);
        setValue('max', maxValue);
        element(by.id('submit')).click();
        return this;
    }

    checkValuesChanged(minValue, maxValue) {
        checkValue('min', minValue);
        checkValue('max', maxValue);
        return this;
    }

    expectNumberOfRiskProfiles(numOfProfiles) {
        const profiles = element.all(by.repeater('rp in ctrl.filteredRiskProfiles()'));
        expect(profiles.count()).toBe(numOfProfiles);
        return this;
    }

    expectRiskProfileToBePresent(title, present = true) {
        expect(element(by.$(`.risk-profile:contains('${title}')`)).isPresent()).toBe(present);
        return this;
    }

    expectDefaultRiskProfileToBeFirst() {
        const firstRiskProfileTitle = element(by.repeater('rp in ctrl.filteredRiskProfiles()').row(0).column('rp.title')).getText();
        expect(firstRiskProfileTitle).toBe('Default risk profile');
        return this;
    }

    filter(title) {
        this.clearFilter();
        $$('#risk-profile-filter').sendKeys(title);
        return this;
    }

    clearFilter() {
        $$('#risk-profile-filter').clear();
        return this;
    }

    openRiskProfile(title) {
        element(by.$(`.risk-profile:contains('${title}')`)).click();
        return new RiskProfilePage();
    }

    deleteRiskProfile(title) {
        element(by.$(`.risk-profile:contains('${title}') .remove-action`)).click();
        Browser.waitFor('.modal-body');
        element(by.css('.modal-footer .primary')).click();
        return this;
    }

    newRiskProfile() {
        element(by.css('.new-risk-profile')).click();
        return new RiskProfilePage();
    }

    copyRiskProfile(title) {
        element(by.$(`.risk-profile:contains('${title}') .copy-action`)).click();
        return this;
    }

    shouldHaveCopyButtonEnabledForRiskProfile(title, enabled = true) {
        expect(element(by.$(`.risk-profile:contains('${title}') .copy-action`)).isPresent()).toBe(enabled);
        return this;
    }

    shouldHaveEditButtonEnabledForRiskProfile(title, enabled = true) {
        expect(element(by.$(`.risk-profile:contains('${title}') .open-action`)).getText()).toBe('Edit');
        return this;
    }

    shouldHaveDeleteButtonEnabledForRiskProfile(title, enabled = true) {
        expect(element(by.$(`.risk-profile:contains('${title}') .remove-action`)).isPresent()).toBe(enabled);
        return this;
    }

    shouldHaveSaveButton(present = true) {
        expect(element(by.id('submit')).isPresent()).toBe(present);
        return this;
    }

    shouldHaveEditButton(present = true) {
        expect(element(by.id('editRisk')).isPresent()).toBe(present);
        return this;
    }

    shouldHaveNewRiskProfileButton(present = true) {
        expect(element(by.css('.new-risk-profile')).isPresent()).toBe(present);
        return this;
    }

    shouldHaveNVisibleRiskProfiles(numberOfVisibleRiskProfiles) {
        expect($$('#risk-profile-table .data-row').count()).toEqual(numberOfVisibleRiskProfiles);
        return this;
    }
}

global.RisksPage = RisksPage;
