class TemplatesListPage {

    addTemplate() {
        return new AddTemplateDropdown('#list-add-template');
    }

    createNewTemplate() {
        element(By.css(".new-template")).click();
        return new TemplatePropertiesPage();
    }

    openTemplateByName(templateName) {
        Browser.waitFor('.template');
        element(By.$(`.template:contains('${templateName}') .title`)).click();
        return new ReleasePage();
    }

    openImportTemplateDialog() {
        element(By.css(".import-template")).click();
        return new ImportTemplateDialog();
    }

    copy(originTitle, targetTitle, optionalArguments) {
        let {expectFailure} = optionalArguments || {};

        element(By.$(`.template:contains('${originTitle}') .copy`)).click();

        let title = element(By.model('ctrl.copyOfTemplate.title'));
        title.clear();
        title.sendKeys(targetTitle);

        let description = element(By.model('ctrl.copyOfTemplate.description'));
        description.clear();
        description.sendKeys('description');

        element(By.$('.modal:visible .continue')).click();
        if (expectFailure) {
            expect(browser.isElementPresent(By.$(`.form-errors li:contains(\"${expectFailure}\"):visible`))).toBe(true);
            element(By.$('.modal:visible .close')).click();
        } else {
            new TemplatePage();
            Page.openTemplatesList();
        }

        return this;
    }

    expectTemplateVisible(title, expected = true) {
        Browser.waitFor(".template");
        expect(element(By.$(`.template:contains('${title}')`))).toBePresent(expected);
        return this;
    }

    createNewTemplate() {
        element(By.css(".new-template")).click();
        return new TemplatePropertiesPage();
    }

    delete(title) {
        element(By.$(`.template:contains('${title}') .delete`)).click();
        element(By.$('.modal .continue')).click();
        return this;
    }

    openMoveDialog(title) {
        Browser.waitFor(`.template:contains(${title})`);
        element(By.$(`.template:contains('${title}') .move`)).click();
        return new MoveDialog();
    }
}


class MoveDialog {
    constructor() {
        Browser.waitFor('folder-explorer');
    }

    selectFolder(folder) {
        element(By.$(`.ui-grid-row-title:contains('${folder}')`)).click();
        return this;
    }

    submitMove() {
        element(By.$('.modal .continue')).click();
        return this;
    }

    expand(folder) {
        let toggleIcon = element(By.$(`.ui-grid-row:contains('${folder}') .toggle-icon`));
        browser.executeScript('arguments[0].click();', toggleIcon.getWebElement());
        return this;
    }

    expectFolderDisabled(disabledFolder) {
        expect(element(By.$(`.modal-body span.can-click-disabled:contains('${disabledFolder}')`))).toBePresent(true);
        return this;
    }

    expectMoveButtonDisabled(enabled) {
        expect(element(By.$("[disabled]"))).toBePresent(enabled);
        return this;
    }

    expectMergeActionEnabled(enabled) {
        expect(element(By.$(`.merge-action input${enabled ? '' : '[disabled]'}`))).toBePresent(true);
        return this;
    }

    expectMovePermissionDialog(folder) {
        expect(element(By.$(`.move-template-permissions:contains(folder takes its permissions from ${folder})`))).toBePresent(true);
        return this;
    }

    chooseOption(name) {
        element(By.$(`.${name.toLowerCase()}-action input`)).click();
        return this;
    }
}


global.TemplatesListPage = TemplatesListPage;
global.MoveDialog = MoveDialog;
