// Used to access a real XL Deploy from integration tests
class XLDeploy {
    static checkDeploymentExists(application, environment) {
        application = `Applications/${application}`;
        environment = `Environments/${environment}`;

        const url = `${browser.params.xlDeployUrl}/deployit/deployment/exists?application=${application}&environment=${environment}`;
        const errorMessage = response => `Deployment for application ${application} and environment ${environment} doesn't exist : ${response.body}`;

        return this.httpGet(url, 'true', errorMessage);
    }

    static expectFileDeployed(fileName, expected) {
        const url = `${browser.params.xlDeployUrl}/deployit/repository/exists/Infrastructure/testHost/${fileName}`;
        const errorMessage = response => `Deployed file not found on ${url} : ${response.body}`;

        return this.httpGet(url, expected != null ? expected : {'true': 'false'}, errorMessage);
    }

    static httpGet(url, expectedResult, errorMessage) {
        return Flow.execute((fulfill, reject) => {
            const options = {
                method: 'GET',
                uri: url,
                auth: {username: 'admin', password: 'admin', sendImmediately: true},
                resolveWithFullResponse: true
            };
            // XLD api responds with <boolean>true</boolean>
            return requestPromise(options).then(response => response.body.indexOf(expectedResult) === -1 ? reject(errorMessage(response)) : fulfill(response),
                error => reject(error.body));
        });
    }
}


global.XLDeploy = XLDeploy;
