class Browser {
    static open() {
        browser.get('#/');
        return this;
    }

    static setDefaultSize() {
        return browser.manage().window().setSize(1280, 800);
    }

    static setSize(width, height) {
        return browser.manage().window().setSize(width, height);
    }

    static expectUrlToBe(url) {
        expect(browser.getCurrentUrl()).toContain(url);
        return this;
    }
    static expectUrlToContain = Browser.expectUrlToBe;

    static wait(conditionFunction, message, timeout = 30000) {
        return browser.wait(conditionFunction, timeout, message);
    }

    static waitFor(cssSelector, timeout) {
        return this.wait(() => element(By.$(cssSelector)).isPresent()
            , `waiting for '${cssSelector}' to be present`
            , timeout);
    }

    static waitForDisplayed(cssSelector, timeout) {
        return this.wait(function () {
                let el = element(By.$(cssSelector));
                return el.isPresent() && el.isDisplayed();
            }
            , `waiting for '${cssSelector}' to be present && displayed`
            , timeout);
    }

    static scrollTo(locator) {
        let scrollIntoView = function () {
            return arguments[0].scrollIntoView();
        };
        return this.executeVoidScript(scrollIntoView, browser.findElement(locator));
    }

    static executeVoidScript(scriptFunction, ...scriptArguments) {
        let script = `(${scriptFunction}).apply(null, arguments);`;
        return browser.executeScript(script, ...scriptArguments);
    }

    static hover(locator) {
        return browser.actions().mouseMove(element(locator)).perform();
    }

    static blurActiveElement() {
        return this.executeVoidScript(() => document.activeElement.blur());
    }

    static clickElseWhere() {
        return this.executeVoidScript(() => $(document).click());
    }

    static softReload() {
        let remoteScript = function () {
            let state = angular.element('body').injector().get('$state');
            return state.reload();
        };

        return Browser.executeVoidScript(remoteScript);
    }
}

global.Browser = Browser;
