const selectRoleRow = roleName => {
    const locator = By.$(`tr:contains('${roleName}')`);
    browser.wait(EC.visibilityOf(element(locator), 3000));
    return element(locator);
};

const populatePrincipalField = principalNames => principalNames.forEach(p => {
    element(By.css('.tag-input')).click();
    element(By.css('.tag-input')).sendKeys(p);
    element(By.css('.tag-input')).sendKeys(protractor.Key.ENTER);
});

const removeExistingPrincipals = () => element(By.css('.tags')).all(By.css('.tag-close')).each(p => p.click());


class RolesPage {
    constructor() {
        Browser.waitFor('#roles .roles-table');
    }

    addNewRole(roleName, principalNames) {
        element(By.css('.new-role')).click();
        Browser.waitFor('.modal-body');
        element(By.css('#rolename')).sendKeys(roleName);
        populatePrincipalField(principalNames);
        element(By.css('.save')).click();
        return this;
    }

    removeRole(roleName) {
        const row = selectRoleRow(roleName);
        row.element(By.css('.remove-action')).click();
        Browser.waitFor('.modal-body');
        element(By.css('.modal-footer .primary')).click();
        return this;
    }

    editRole(roleName, principalNames) {
        const row = selectRoleRow(roleName);
        row.element(By.$(`.action:contains('Edit role')`)).click();
        Browser.waitFor('.modal-body');
        removeExistingPrincipals();
        populatePrincipalField(principalNames);
        element(By.css('.save')).click();
        return this;
    }

    expectListHasRole(roleName, principalNames) {
        browser.sleep(1000);
        const row = selectRoleRow(roleName);
        const principals = row.all(By.css('.tag-label'));
        expect(principals.count()).toBe(principalNames.length);
        expect(principals.getText()).toEqual([...principalNames]);
        return this;
    }
}

global.RolesPage = RolesPage;
