let firstTime = true;

const setup = function () {
    if (firstTime) {
        firstTime = false;
        Server.request('PUT', 'settings/ci/Configuration/settings/ArchivingSettings', {
            id: "Configuration/settings/ArchivingSettings",
            type: "xlrelease.ArchivingSettings",
            releaseAgeToDeleteFromJcr: 438000
        }); // 50 years
    }
    jasmine.addMatchers({
        toBeDisplayed() {
            return {
                compare(actual, displayed = true) {
                    return {
                        pass: actual.isDisplayed().then(value => value === displayed),
                        message: `Expected element ${actual.locator()} ${displayed ? '' : 'not '}to be displayed`
                    };
                }
            };
        },
        toBePresent() {
            return {
                compare(actual, present = true) {
                    return {
                        pass: actual.isPresent().then(value => value === present),
                        message: `Expected element ${actual.locator()} ${present ? '' : 'not '}to be present`
                    };
                }
            };
        }
    });
    Errors.clearErrors();
    return Errors.ignoreErrors(false);
};

const cleanup = function () {
    Errors.expectNoHttpError();
    Browser.setDefaultSize();
    LoginPage.logout();
    Page.clearClientSettings();
    fixtures().clean(); // remove this after the plugin tests have been adopted to run in paralell
    element.all(By.css('.modal')).then(items => items.map((item) => expect(item).toBeDisplayed(false)));
};

global.globalForAll = function () {
    beforeAll(() => setup());
    afterAll(() => {
        fixtures().clean();
        cleanup();
    });
};

global.globalForEach = function () {
    beforeEach(() => setup());
    afterEach(() => cleanup());
};

global.isolatedWindow = () => {
    beforeAll(() => Browser.switchToNewWindow());
    afterAll(() => Browser.backToOriginalWindow());
};
