class MainMenuPage {
    constructor() {
        Browser.waitFor('#main-menu');
    }

    expectMenu(title) {
        expect(element(By.$(`.menu-level-0 .menu-element:contains('${title}')`))).toBeDisplayed();
        return this;
    }

    hoverMenu(title) {
        Browser.hover(By.$(`.menu-level-0 .menu-element:contains('${title}')`));
        return this;
    }

    expectSubMenu(title) {
        expect(element(By.$(`.menu-level-1 li:contains('${title}')`))).toBeDisplayed();
        return this;
    }

    selectSubMenu(title) {
        element(By.$(`.menu-level-1 a:contains('${title}')`)).click();
        return this;
    }
}


global.MainMenuPage = MainMenuPage;
