class PermissionsPage {
    constructor() {
        Browser.waitFor('#permissions .table');
    }

    uncheck(role, permission) {
        element(By.$(`tr:contains('${role}') .permission-${permission} .permission-checked:visible`)).click();
        return this;
    }

    expectChecked(role, permission) {
        expect(element.all(By.$(`tr:contains('${role}') .permission-${permission} .permission-checked:visible`)).count()).toEqual(1);
        return this;
    }

    expectSaveButtonInvisible() {
        expect(element.all(By.$(".save:visible")).count()).toEqual(0);
        return this;
    }

    addRoleToPermission(role, permission) {
        const input = element.all(By.$(`tr:contains('${permission}') .tag-input`));
        input.sendKeys(role);
        input.sendKeys(protractor.Key.ENTER);
        element.all(By.$(".save:visible")).click();
    }
    addAndSaveAsAdmin(role) {
        this.addRoleToPermission(role, 'Admin');
        return this;
    }
    addAndSaveAsEdit(role) {
        this.addRoleToPermission(role, 'Edit security');
        return this;
    }
    addAndSaveAsTemplateCreaters(role) {
        this.addRoleToPermission(role, 'Create template');
        return this;
    }
    addAndSaveAsEditGlobalVariables(role) {
        this.addRoleToPermission(role, 'Edit global variables');
        return this;
    }
    addAndSaveAsCreateTopLevelFolders(role) {
        this.addRoleToPermission(role, 'Create top level folders');
        return this;
    }
}

global.PermissionsPage = PermissionsPage;

class ReleasePermissionsPage {
    constructor() {
        Browser.waitFor('#release-permissions #permissions-table');
    }

    expectSaveButtonDisabled() {
        expect(element.all(By.$(".save:disabled")).count()).toEqual(1);
        return this;
    }

    expectTeamMember(teamName, memberName, present) {
        expect(element(By.$(`#teams-permissions-table tr:contains('${teamName}')`))).toBePresent();
        expect(element(By.$(`#teams-permissions-table tr:contains('${teamName}'):contains('${memberName}')`))).toBePresent(present);
        return this;
    }

    expectPermissionGranted(permissionName, teamName, granted) {
        expect(element(By.$(`#permissions-table tr:contains('${permissionName}')`))).toBePresent();
        expect(element(By.$(`#permissions-table tr:contains('${permissionName}'):contains('${teamName}')`))).toBePresent(granted);
        return this;
    }

    expectInheritMessagePresent(folder) {
        expect(element(By.$("p")).getText()).toContain(`Permissions and Teams are inherited from the folder ${folder}`);
        return this;
    }
}


global.ReleasePermissionsPage = ReleasePermissionsPage;
