let listSelector = undefined;
class TriggersPage {
    static initClass() {
        listSelector = "#triggers";
    }

    constructor() {
        Browser.waitFor(listSelector);
    }

    setAllowConcurrentReleasesFromTriggerAndSubmit(checked) {
        let checkbox = element(By.css('#templateForm-allowConcurrentReleasesFromTrigger'));
        if (checkbox.getAttribute('checked') !== checked) {
            checkbox.click();
        }
        element(By.css('#templateForm-save')).click();
        return this;
    }

    expectAllowConcurrentReleasesFromTrigger(expectedValue) {
        let selector = '#templateForm-allowConcurrentReleasesFromTrigger';
        if (expectedValue) {
            selector += ":checked";
        } else {
            selector += ":not(:checked)";
        }

        expect(element.all(By.$(selector)).count() !== 0).toBeTruthy();
        return this;
    }

    newTrigger(type) {
        element(By.$(`.trigger-types option[value$='${type}']`)).click();
        return new TriggerEditPage();
    }

    expectNoNewTriggerDropdownShown() {
        expect(element(By.$(".trigger-types"))).toBePresent(false);
        return this;
    }

    deleteTrigger(title) {
        let rowSelector = `${listSelector} tr:contains('${title}')`;
        element(By.$(`${rowSelector} .remove-icon:last`)).click();
        expect(element(By.$(rowSelector)).isPresent()).toBe(false);
        return this;
    }

    editTrigger(title) {
        element(By.$(`${listSelector} .link:contains('${title}')`)).click();
        return new TriggerEditPage();
    }

    checkTriggerTitle(expectedTitle) {
        expect(element(By.$(`${listSelector} .link:contains('${expectedTitle}')`)).getText()).toEqual(expectedTitle);
        return this;
    }

    openTriggerTypes() {
        element(By.$(".trigger-types")).click();
        return this;
    }

    goOnRelatedReleasesOf(triggerName) {
        let rowSelector = `${listSelector} tr:contains('${triggerName}')`;
        element(By.$(`${rowSelector} .open-related-release .link`)).click();
        return new ReleasesListPage();
    }
}
TriggersPage.initClass();

global.TriggersPage = TriggersPage;
