class Server {
    static doRequest(type, url, data) {
        const options = {
            method: type,
            body: data,
            uri: `${browser.baseUrl}/${url}`,
            json: true,
            auth: {username: 'admin', password: 'admin', sendImmediately: true},
            resolveWithFullResponse: true
        };
        return requestPromise(options);
    }

    static request(type, url, data) {
        return Flow.execute((fulfill, reject) =>
            Server.doRequest(type, url, data).then(fulfill, error => reject(error.body))
        );
    }

    static requestWhile(type, url, data, conditionFn) {
        Flow.execute(fulfill => {
            const check = condition =>
                setTimeout(() => condition ? Server.doRequest(type, url, data).then(response => check(conditionFn(response.body))) : fulfill(), 1000);
            return check(true);
        });
        return this;
    }

    static waitForFirstPoll(templateId, triggerTitle) {
        this.requestWhile('GET', `releases/${templateId}/triggers`, {}, function (templates) {
            const trigger = _.find(templates, {title: triggerTitle});
            return trigger.properties.commitId === null;
        });
        return this;
    }

    static waitForReleaseStarted(releaseTitle) {
        this.requestWhile('POST', 'releases/search', {
            inProgress: true,
            paused: true,
            failing: true,
            failed: true,
            title: releaseTitle
        }, page => page.cis.length === 0);
        return this;
    }

    static waitForReleaseCompleted(releaseTitle) {
        this.requestWhile('POST', 'releases/search', {
            title: releaseTitle,
            completed: true,
        }, page => page.cis.length === 0);
        return this;
    }

    static waitForReleaseAborted(releaseTitle) {
        this.requestWhile('POST', 'releases/search', {
            title: releaseTitle,
            aborted: true,
        }, page => page.cis.length === 0);
        return this;
    }

    static waitForCommentToBeAdded(taskId, comment) {
        return this.requestWhile('POST', `fixtures/expectCommentAdded/${taskId}`, comment, success => success === true);
    }
}

global.Server = Server;
