class UsersPage {
    constructor() {
        Browser.waitFor('#users .table');
    }

    waitForUsersRefreshed() {
        return new UsersPage();
    }

    addUser() {
        element(By.css('.new-user')).click();
        return new UserModal;
    }

    deleteUser(username) {
        element(By.$(`tr:contains('${username}') .delete-user`)).click();
        element(By.css('.modal .continue')).click();
        return this;
    }

    toggleLoginPermission(username) {
        element(By.$(`tr:contains('${username}') .login-permission input`)).click();
        return this;
    }

    expectToHaveLoginPermission(username) {
        expect(element(By.$(`tr:contains('${username}') .login-permission input:checked`))).toBeDisplayed();
        return this;
    }

    expectUserExists(username, email, fullName) {
        const selector = `tr:has(td:contains('${username}')):has(td:contains('${email}')):has(td:contains('${fullName}'))`;
        expect(element(By.$(selector))).toBePresent();
        return this;
    }

    expectNoUser(username) {
        const selector = `tr:has(td:contains('${username}'))`;
        expect(element.all(By.$(selector)).count()).toBe(0);
        return this;
    }

    expectUsers(...users) {
        for (let user of users) {
            expect(element.all(By.$(`tr:contains('${user.name}')`)).count()).toBe(1);
            let type = user.external ? "External" : "Internal";
            expect(element.all(By.$(`tr:contains('${user.name}') td.type:contains('${type}')`)).count()).toBe(1);
            if (user.email != null) {
                expect(element.all(By.$(`tr:contains('${user.name}') td.email:contains('${user.email}')`)).count()).toBe(1);
            }
            if (user.fullName != null) {
                expect(element.all(By.$(`tr:contains('${user.name}') td.full-name:contains('${user.fullName}')`)).count()).toBe(1);
            }

            let delete_link_count = user.external ? 0 : 1;
            expect(element.all(By.$(`tr:contains('${user.name}') td.delete-user`)).count()).toBe(delete_link_count);
        }
        return this;
    }
}

class UserModal {
    setName(name) {
        element(By.model('users.editedUser.username')).sendKeys(name);
        return this;
    }

    setFullName(fullName) {
        element(By.model('users.editedUser.fullName')).sendKeys(fullName);
        return this;
    }

    setPassword(password) {
        element(By.model('users.editedUser.password')).sendKeys(password);
        element(By.model('users.editedUser.passwordConfirmation')).sendKeys(password);
        return this;
    }

    setEmail(email) {
        element(By.model('users.editedUser.email')).sendKeys(email);
        return this;
    }

    save() {
        element(By.css('.modal .button.save')).click();
        return this;
    }

    cancel() {
        element(By.css('.modal .button.cancel')).click();
        return this;
    }
}


global.UsersPage = UsersPage;
