class VariablesEditor {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.variablesEditor = element(By.$(this.path));
    }

    expectVariablesDisplayed(variables, editable = true) {
        expect(this.variablesEditor.all(By.css(".form-group")).count()).toBe(variables.length);
        this.variablesEditor.all(By.css(".form-group")).then(elements => {
                _.zip(variables, elements).forEach(([variable, item]) => {
                    expect(item.getText()).toContain(variable.name);
                    if (variable.isDropDownList) {
                        if (editable) {
                            expect(item.element(By.$('select')).getAttribute('value')).toEqual(`string:${variable.value}`);
                        } else {
                            expect(item.element(By.css('span.read-only > span')).getText()).toEqual(variable.value)
                        }
                    } else {
                        expect(editable ? item.element(By.$('input')).getAttribute('value') :
                            item.element(By.css('span.read-only')).getText()).toEqual(variable.value);
                    }
                });
            }
        );
        return this;
    }

    setVariableValue(key, value) {
        new InlineEditor(`${this.path} .form-group:contains('${key}') div[inline-text-editor]`)
            .set(value);
        return this;
    }

    getStringListField(key) {
        return new XlrListStringWithVariables(`${this.path} #${key}`);
    }
}


global.VariablesEditor = VariablesEditor;