class DipListString {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.dipListString = element(By.$(this.path));
        this.addBtn = this.dipListString.element(By.css(".xl-btn-add"));
        this.inputField = this.dipListString.element(By.css(".dip-input input"));
    }

    add() {
        this.addBtn.click();
        return this;
    }

    focus() {
        this.inputField.click();
        return this;
    }

    enter(text) {
        this.inputField.sendKeys(text);
        return this;
    }

    removeFirstItem() {
        this.dipListString.all(By.$("li .xl-btn-close:visible")).first().click();
        return this;
    }

    getItems() {
        return this.dipListString.all(By.css(".xl-dip-list ul li")).filter(elem => elem.isDisplayed());
    }

    shouldHaveSize(expectedSize) {
        expect(this.getItems().count()).toBe(expectedSize, `Should contain ${expectedSize} item(s)`);
        return this;
    }

    shouldHaveItems(expectedItems) {
        this.shouldHaveSize(expectedItems.length);
        let iterable = this.getItems();
        for (let i = 0; i < iterable.length; i++) {
            let item = iterable[i];
            expect(item.getText()).toContain(expectedItems[i]);
        }
        return this;
    }

    expectAddIsNotVisible() {
        expect(this.addBtn.isDisplayed()).toBe(false, 'Add button should not be displayed');
        return this;
    }

    expectInputIsNotVisible() {
        expect(this.inputField.isDisplayed()).toBe(false, 'Input should not be visible');
        return this;
    }
}


global.DipListString = DipListString;