class LoginPage {
    static login(login, password) {
        LoginPage.recoverFromForbiddenAccess();
        Browser.waitForDisplayed('#login', 2000);
        element(By.model('loginInfo.login')).clear();
        element(By.model('loginInfo.login')).sendKeys(login);
        element(By.model('loginInfo.password')).sendKeys(password);
        element(By.css('#login .login-button button')).click();
        browser.waitForAngular();
        LoginPage.recoverFromForbiddenAccess();
        // if is releases list page => waitForReleasesLoaded()
        /*if(browser.getCurrentUrl().indexOf('releases') !== -1)
            ReleasesListPage().waitFor('.releases-list-loaded:visible');*/
        return this;
    }

    static recoverFromForbiddenAccess() {
        return browser.sleep(2000).then(() => {
            return element.all(By.$('h3:contains("Forbidden access")')).count().then(c => {
                if (c) {
                    return browser.executeScript("arguments[0].click();", element(By.$('a.logo-link:visible'))).then(() => browser.sleep(2000));
                }
            });
        });
    }

    static manuallyLogout() {
        element(By.css('.current-user .dropdown-button.settings')).click();
        element(By.css('.logout.action')).click();
        browser.waitForAngular();
        return this;
    }

    static logout() {
        browser.setLocation('/login');
        browser.waitForAngular();
        TaskPolling.waitForPollRequest();
        return this;
    }

    static expectLoginDisallowed() {
        expect(browser.getCurrentUrl()).toMatch(/login/);
        expect(element(By.$('.error-content > span:visible')).getText()).toContain("Permission 'login' is not granted to you.");
        return this;
    }

    static expectToBeLogged(username) {
        expect(element(By.css('.current-user')).getText()).toContain(`Logged in as ${username}`);
        return this;
    }
}


global.LoginPage = LoginPage;
