class NotificationSettingsPage {
    constructor() {
        Browser.waitFor(".notification-settings");
    }

    addTaskRole(roleName, pos) {
        new TagEditor(`.tags:nth(${pos})`).addTag(roleName);
        return this;
    }

    removeTaskRole(roleName, pos) {
        new TagEditor(`.tags:nth(${pos})`).removeTag(roleName);
        return this;
    }

    openEditMessage(pos) {
        element(by.$(`a.action:nth(${pos})`)).click();
        return new EditMessage();
    }

    submit() {
        element(By.buttonText('Save')).click();
        return this;
    }

    expectUpdatedWith(teamName, pos) {
        new TagEditor(`.tags:nth(${pos})`).expectTaggedWith(teamName);
        return this;
    }
}

class EditMessage {

    constructor() {
        const selector = ".edit-email";
        Browser.waitFor(selector);
        this.editor = element(By.css(selector));
    }

    setSubject(text) {
        new InlineEditor(`.edit-email div[inline-text-editor][name='subject']`).set(text);
        return this;
    }

    setPriority(priority) {
        this.editor.element(by.model('$ctrl.event.priority')).$(`[label='${priority}']`).click();
        return this;
    }

    setBody(text) {
        new TextareaInlineEditor(`.edit-email div[inline-textarea-editor][name='body']`).set(text);
        return this;
    }

    reset(subject, body) {
        new InlineEditor(`.edit-email div[inline-text-editor][name='subject']`).set(subject);
        new TextareaInlineEditor(`.edit-email div[inline-textarea-editor][name='body']`).set(body);
        this.save();
    }

    hasSubject(text) {
        const inlineEditor = new TextareaInlineEditor(`.edit-email div[inline-text-editor][name='subject']`);
        expect(inlineEditor.value()).toBe(text);
        return this;
    }

    hasPriority(priority) {
        expect(this.editor.element(by.css('option:checked')).getText()).toBe(priority);
        return this;
    }

    hasBody(text) {
        const inlineEditor = new TextareaInlineEditor(`.edit-email div[inline-textarea-editor][name='body']`);
        expect(inlineEditor.value()).toBe(text);
        return this;
    }

    save() {
        this.editor.element(by.css('.primary')).click();
    }

    revert() {
        this.editor.element(by.css('.button.cancel')).click();
        element(by.cssContainingText('.continue', 'Leave')).click();
    }

}

global.NotificationSettingsPage = NotificationSettingsPage;