/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.writer.DefinitionWriter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.CreationService;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.service.FolderSearch;
import com.xebialabs.xlrelease.ascode.service.FolderSearch$;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.service.GenerateService$CisConfig$;
import com.xebialabs.xlrelease.ascode.service.GenerateService$GeneratorConfig$;
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter;
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter$;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.scm.connector.Repository;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.data.GitTag;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo$;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\rh\u0001\u0002\u0012$\u0001AB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\t\u0001!\u0002\u0013\tI\u0003\u0003\u0006\u0002D\u0001A)\u0019!C\u0001\u0003\u000bBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"I\u00111\u0018\u0001\u0012\u0002\u0013\u0005\u0011Q\u0018\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\ti\u000e\u0001C\u0001\u0003?DqAa\u0005\u0001\t\u0003\u0011)\u0002C\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!q\u0006\u0001\u0005\u0002\tE\u0002b\u0002B\u001d\u0001\u0011\u0005!1\b\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{BqA!!\u0001\t\u0013\u0011\u0019\tC\u0004\u0003\n\u0002!IAa#\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\"9!\u0011\u0015\u0001\u0005\n\t\r\u0006b\u0002BU\u0001\u0011%!1\u0016\u0005\b\u0005\u0017\u0004A\u0011\u0002Bg\u0005]1u\u000e\u001c3feZ+'o]5p]&twmU3sm&\u001cWM\u0003\u0002%K\u0005\u00191oY7\u000b\u0005\u0019:\u0013AB1tG>$WM\u0003\u0002)S\u0005Qa/\u001a:tS>t\u0017N\\4\u000b\u0005)Z\u0013!\u0003=me\u0016dW-Y:f\u0015\taS&A\u0005yK\nL\u0017\r\\1cg*\ta&A\u0002d_6\u001c\u0001aE\u0002\u0001c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0014\u0001C4sSjTH.\u001a3\n\u0005yJ$a\u0002'pO\u001eLgnZ\u0001\u0013kN,'\u000f\u0015:pM&dWmU3sm&\u001cW\r\u0005\u0002B\t6\t!I\u0003\u0002DS\u000591/\u001a:wS\u000e,\u0017BA#C\u0005I)6/\u001a:Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001S&\u000e\u0003%S!a\u0011&\u000b\u0005\u0019J\u0013B\u0001'J\u0005=9UM\\3sCR,7+\u001a:wS\u000e,\u0017aD2sK\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005!{\u0015B\u0001)J\u0005=\u0019%/Z1uS>t7+\u001a:wS\u000e,\u0017\u0001\u00053fM&t\u0017\u000e^5p]B\u000b'o]3s!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0004qCJ\u001cXM\u001d\u0006\u0003/*\u000bA!_1nY&\u0011\u0011\f\u0016\u0002\u001412\u0013F)\u001a4j]&$\u0018n\u001c8QCJ\u001cXM]\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001X0\u000e\u0003uS!AX\u0015\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002a;\n92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\u001dG>tg-[4ve\u0006$\u0018n\u001c8WCJL\u0017M\u00197f'\u0016\u0014h/[2f!\t\t5-\u0003\u0002e\u0005\na2i\u001c8gS\u001e,(/\u0019;j_:4\u0016M]5bE2,7+\u001a:wS\u000e,\u0017\u0001F2p]\u001aLw-\u001e:bi&|gnU3sm&\u001cW\r\u0005\u0002BO&\u0011\u0001N\u0011\u0002\u0015\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002'\u0019|G\u000eZ3s\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u0011\u0005![\u0017B\u00017J\u0005M1u\u000e\u001c3fe\u0006\u001b8i\u001c3f'\u0016\u0014h/[2f\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"!Q8\n\u0005A\u0014%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002Bg&\u0011AO\u0011\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u000fofT8\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003!\tA\b!D\u0001$\u0011\u0015y4\u00021\u0001A\u0011\u001515\u00021\u0001H\u0011\u0015i5\u00021\u0001O\u0011\u0015\t6\u00021\u0001S\u0011\u0015Q6\u00021\u0001\\\u0011\u0015\t7\u00021\u0001c\u0011\u0015)7\u00021\u0001g\u0011\u0015I7\u00021\u0001k\u0011\u0015i7\u00021\u0001o\u0011\u0015\t8\u00021\u0001sQ\rY\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t#\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003'\t)\"A\u0004gC\u000e$xN]=\u000b\t\u0005]\u0011\u0011D\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u00037\ti\"A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty\"A\u0002pe\u001eLA!a\t\u0002\u000e\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u0007G&$\u0016\u0010]3\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003{i!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\be\u00164G.Z2u\u0015\u0011\t\u0019$!\u000e\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00028\u0005e\u0012A\u00029mk\u001eLgNC\u0002\u0002<-\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003\u007f\tiC\u0001\u0003UsB,\u0017aB2j)f\u0004X\rI\u0001\u000foJ\f\u0007/\u0012=dKB$\u0018n\u001c8t+\t\t9\u0005\u0005\u0004\u0002J\u0005%\u0014q\u000e\b\u0005\u0003\u0017\n\u0019G\u0004\u0003\u0002N\u0005uc\u0002BA(\u00033rA!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+z\u0013A\u0002\u001fs_>$h(C\u00015\u0013\r\tYfM\u0001\u0005kRLG.\u0003\u0003\u0002`\u0005\u0005\u0014aB2p]R\u0014x\u000e\u001c\u0006\u0004\u00037\u001a\u0014\u0002BA3\u0003O\n\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\t\u0005}\u0013\u0011M\u0005\u0005\u0003W\niGA\u0003DCR\u001c\u0007N\u0003\u0003\u0002f\u0005\u001d\u0004c\u0001\u001a\u0002r%\u0019\u00111O\u001a\u0003\u000f9{G\u000f[5oO\u0006aa-\u001b8e'\u0016$H/\u001b8hgR!\u0011\u0011PAH!\u0015\u0011\u00141PA@\u0013\r\tih\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007S1AJAC\u0015\rA\u0013q\u0011\u0006\u0004\u0003\u0013K\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002\u000e\u0006\r%\u0001\u0007$pY\u0012,'OV3sg&|g.\u001b8h'\u0016$H/\u001b8hg\"9\u0011\u0011S\bA\u0002\u0005M\u0015\u0001\u00034pY\u0012,'/\u00133\u0011\t\u0005U\u0015Q\u0014\b\u0005\u0003/\u000bI\nE\u0002\u0002RMJ1!a'4\u0003\u0019\u0001&/\u001a3fM&!\u0011qTAQ\u0005\u0019\u0019FO]5oO*\u0019\u00111T\u001a\u0002\u0017\u001d,GoU3ui&twm\u001d\u000b\u0005\u0003\u007f\n9\u000bC\u0004\u0002\u0012B\u0001\r!a%\u0002-\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKN+G\u000f^5oON$b!a \u0002.\u0006E\u0006bBAX#\u0001\u0007\u0011qP\u0001\n]\u0016<8i\u001c8gS\u001eD\u0011\"a-\u0012!\u0003\u0005\r!!.\u0002!\u0005\u0004\b\u000f\\=WC2LG-\u0019;j_:\u001c\bc\u0001\u001a\u00028&\u0019\u0011\u0011X\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\u00013M]3bi\u0016|%/\u00169eCR,7+\u001a;uS:<7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyL\u000b\u0003\u00026\u0006\u00057FAAb!\u0011\t)-!4\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=1'\u0003\u0003\u0002P\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qA-\u001a7fi\u0016\u001cV\r\u001e;j]\u001e\u001cH\u0003BAk\u00037\u00042AMAl\u0013\r\tIn\r\u0002\u0005+:LG\u000fC\u0004\u0002\u0012N\u0001\r!a%\u0002\u0017\u001d,GOV3sg&|gn\u001d\u000b\u0005\u0003C\u0014\t\u0002E\u00043\u0003G\f9/!>\n\u0007\u0005\u00158G\u0001\u0004UkBdWM\r\t\u0005\u0003S\f\t0\u0004\u0002\u0002l*!\u00111LAw\u0015\t\ty/\u0001\u0003kCZ\f\u0017\u0002BAz\u0003W\u0014A\u0001R1uKB1\u0011q_A\u007f\u0005\u0007qA!a\u0014\u0002z&\u0019\u00111`\u001a\u0002\u000fA\f7m[1hK&!\u0011q B\u0001\u0005\r\u0019V-\u001d\u0006\u0004\u0003w\u001c\u0004\u0003\u0002B\u0003\u0005\u001bi!Aa\u0002\u000b\t\t%!1B\u0001\u0005I\u0006$\u0018M\u0003\u0002%S%!!q\u0002B\u0004\u0005-1VM]:j_:LeNZ8\t\u000f\u0005EE\u00031\u0001\u0002\u0014\u0006aa-\u001a;dQ\u000eC\u0017M\\4fgR!\u0011\u0011\u001dB\f\u0011\u001d\t\t*\u0006a\u0001\u0003'\u000bQb\u0019:fCR,g+\u001a:tS>tG\u0003\u0003B\u0002\u0005;\u0011yBa\t\t\u000f\u0005Ee\u00031\u0001\u0002\u0014\"9!\u0011\u0005\fA\u0002\u0005M\u0015a\u0002<feNLwN\u001c\u0005\b\u0005K1\u0002\u0019AAJ\u0003-!Wm]2sSB$\u0018n\u001c8\u0002\u0019\u0005\u0004\b\u000f\\=WKJ\u001c\u0018n\u001c8\u0015\r\u0005U'1\u0006B\u0017\u0011\u001d\t\tj\u0006a\u0001\u0003'CqA!\t\u0018\u0001\u0004\t\u0019*A\bhK:,'/\u0019;f!J,g/[3x)\u0019\t\u0019Ja\r\u00036!9\u0011\u0011\u0013\rA\u0002\u0005M\u0005b\u0002B\u00111\u0001\u0007!q\u0007\t\u0006e\u0005m\u00141S\u0001\u000eS:LGoQ8o]\u0016\u001cGo\u001c:\u0015\t\tu\"\u0011\n\t\u0005\u0005\u007f\u0011)%\u0004\u0002\u0003B)\u0019!1I\u0012\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B$\u0005\u0003\u00121#Q:D_\u0012,'jR5u\u0007>tg.Z2u_JDqAa\u0013\u001a\u0001\u0004\ty(\u0001\u0004d_:4\u0017nZ\u0001\u000fO\u0016tWM]1uK\u001a{G\u000eZ3s)!\u0011\tFa\u001d\u0003v\t]\u0004c\u0002\u001a\u0002d\nM#Q\f\t\u0005\u0005+\u0012I&\u0004\u0002\u0003X)!!1\tB\u0006\u0013\u0011\u0011YFa\u0016\u0003\u0011M\u001bWN\u00117pEN\u0004b!a>\u0003`\t\r\u0014\u0002\u0002B1\u0005\u0003\u0011A\u0001T5tiB!!Q\rB8\u001b\t\u00119G\u0003\u0003\u0003j\t-\u0014!B7pI\u0016d'bA,\u0003n)\u0011aeK\u0005\u0005\u0005c\u00129G\u0001\u0006EK\u001aLg.\u001b;j_:Dq!!%\u001b\u0001\u0004\t\u0019\nC\u0004\u0003Li\u0001\r!a \t\u000f\te$\u00041\u0001\u0002\u0014\u0006Aa-\u001b7f!\u0006$\b.\u0001\twC2LG-\u0019;f'\u0016$H/\u001b8hgR!\u0011Q\u001bB@\u0011\u001d\u0011Ye\u0007a\u0001\u0003\u007f\nQC^1mS\u0012\fG/Z*qK\u000eLg-[2bi&|g\u000e\u0006\u0003\u0002V\n\u0015\u0005b\u0002BD9\u0001\u0007\u00111S\u0001\u0005gB,7-A\u0006nKR\fG-\u0019;b\u001b\u0006\u0004H\u0003\u0002BG\u0005+\u0003RAMA>\u0005\u001f\u0003\u0002\"!&\u0003\u0012\u0006M\u00151S\u0005\u0005\u0005'\u000b\tKA\u0002NCBDq!!%\u001e\u0001\u0004\t\u0019*\u0001\u0007fqR\u0014\u0018m\u0019;Ta\u0016\u001c7\u000f\u0006\u0003\u0003\u001c\nu\u0005CBA|\u0003{\f\u0019\nC\u0004\u0003 z\u0001\rAa\u0015\u0002\u000b\tdwNY:\u0002\u001b5\f'o[!t\u0003B\u0004H.[3e)\u0019\t)N!*\u0003(\"9!\u0011E\u0010A\u0002\u0005M\u0005b\u0002B&?\u0001\u0007\u0011qP\u0001\u001aCB\u0004H._*d[\u0012\u000bG/\u0019+p\t\u00164\u0017N\\5uS>t7\u000f\u0006\u0004\u0002V\n5&1\u0017\u0005\b\u0005_\u0003\u0003\u0019\u0001BY\u0003-!WMZ5oSRLwN\\:\u0011\r\u0005]\u0018Q B2\u0011\u001d\u0011)\f\ta\u0001\u0005o\u000bqa]2n\t\u0006$\u0018\r\u0005\u0003\u0003:\n\u001dWB\u0001B^\u0015\u0011\u0011iLa0\u0002\u0007\u0011$xN\u0003\u0003\u0003B\n\r\u0017aA2pG*\u0019!QY\u0016\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u0003\u0003J\nm&aE*D\u001bR\u0013\u0018mY3bE&d\u0017\u000e^=ECR\f\u0017AF4fiN\u001bW\u000e\u0016:bG\u0016\f'-\u001b7jif$\u0015\r^1\u0015\r\t]&q\u001aBi\u0011\u001d\u0011Y%\ta\u0001\u0003\u007fBqAa5\"\u0001\u0004\u0011\u0019!A\u0006wKJ\u001c\u0018n\u001c8J]\u001a|\u0007f\u0001\u0001\u0003XB!!\u0011\u001cBp\u001b\t\u0011YN\u0003\u0003\u0003^\u0006e\u0011AC:uKJ,w\u000e^=qK&!!\u0011\u001dBn\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class FolderVersioningService
implements Logging {
    private Exception.Catch<Nothing$> wrapExceptions;
    private final UserProfileService userProfileService;
    private final GenerateService generateService;
    private final CreationService creationService;
    private final XLRDefinitionParser definitionParser;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationVariableService configurationVariableService;
    private final ConfigurationService configurationService;
    private final FolderAsCodeService folderAsCodeService;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final Type ciType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Type ciType() {
        return this.ciType;
    }

    private Exception.Catch<Nothing$> wrapExceptions$lzycompute() {
        FolderVersioningService folderVersioningService = this;
        synchronized (folderVersioningService) {
            if (!this.bitmap$0) {
                this.wrapExceptions = Exception$.MODULE$.catchingPromiscuously((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{AsCodeException.class, GitAPIException.class, JGitInternalException.class})).withApply((Function1 & Serializable)e -> {
                    throw new ScmException(new StringBuilder(44).append("Error performing version control operation: ").append(e.getMessage()).toString(), e.getCause(), ScmException$.MODULE$.apply$default$3());
                });
                this.bitmap$0 = true;
            }
        }
        return this.wrapExceptions;
    }

    public Exception.Catch<Nothing$> wrapExceptions() {
        return !this.bitmap$0 ? this.wrapExceptions$lzycompute() : this.wrapExceptions;
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return (Option)this.wrapExceptions().apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala($this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption());
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)this.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("No version control settings defined for folder", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig, boolean applyValidations) {
        return (FolderVersioningSettings)((Object)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings folderVersioningSettings;
            Option<FolderVersioningSettings> option;
            if (applyValidations) {
                this.validateSettings(newConfig);
            }
            if ((option = this.findSettings(newConfig.getFolderId())) instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings existingConfig = (FolderVersioningSettings)((Object)((Object)some.value()));
                existingConfig.updateWith(newConfig);
                folderVersioningSettings = existingConfig;
            } else if (None$.MODULE$.equals(option)) {
                newConfig.setId($this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_ID_ROOT()));
                folderVersioningSettings = newConfig;
            } else {
                throw new MatchError(option);
            }
            FolderVersioningSettings config = folderVersioningSettings;
            $this.configurationService.createOrUpdate((BaseConfiguration)config);
            return config;
        }));
    }

    public boolean createOrUpdateSettings$default$2() {
        return true;
    }

    public void deleteSettings(String folderId) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option<FolderVersioningSettings> option = this.findSettings(folderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                FolderVersioningSettings config = (FolderVersioningSettings)((Object)((Object)some.value()));
                $this.configurationRepository.delete(config.getId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> getVersions(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.listVersions();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$1 -> x$1.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public Tuple2<Date, Seq<VersionInfo>> fetchChanges(String folderId) {
        return (Tuple2)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            Seq<VersionInfo> versions = scmConnector.pullAndListVersions();
            config.lastFetched_$eq(new Date());
            $this.configurationRepository.update((BaseConfiguration)config);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.lastFetched()), versions.sortBy((Function1 & Serializable)x$2 -> x$2.commitTime(), package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse()));
        });
    }

    public VersionInfo createVersion(String folderId, String version, String description) {
        return (VersionInfo)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Tuple2<ScmBlobs, List<Definition>> tuple2 = this.generateFolder(folderId, config, filePath);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ScmBlobs blobs = (ScmBlobs)tuple2._1();
            List definitions = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)blobs, (Object)definitions);
            Tuple2 tuple23 = tuple22;
            ScmBlobs blobs2 = (ScmBlobs)tuple23._1();
            List definitions2 = (List)tuple23._2();
            GitTag tag = new GitTag((String)FolderVersioningSettings$.MODULE$.generateTagName(config.getEffectiveTagPrefix(), version, FolderVersioningSettings$.MODULE$.generateTagName$default$3()).get());
            ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, tag).get();
            UserProfile userProfile = $this.userProfileService.findByUsername(Permissions.getAuthenticatedUserName());
            scmConnector.createNewVersion(blobs2, commitInfo, userProfile).get();
            VersionInfo versionInfo = scmConnector.getVersion(commitInfo.tag().refName());
            SCMTraceabilityData scmData = this.getScmTraceabilityData(config, versionInfo);
            this.markAsApplied(versionInfo.name(), config);
            this.applyScmDataToDefinitions((Seq<Definition>)definitions2, scmData);
            return versionInfo;
        });
    }

    public void applyVersion(String folderId, String version) {
        this.wrapExceptions().apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            AsCodeJGitConnector scmConnector = this.initConnector(config);
            VersionInfo versionInfo = scmConnector.getVersion(version);
            SCMTraceabilityData scmData = this.getScmTraceabilityData(config, versionInfo);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            ScmBlobs blobs = (ScmBlobs)scmConnector.checkout(filePath, version, scmConnector.checkout$default$3()).get();
            Seq<String> specs = this.extractSpecs(blobs);
            specs.foreach((Function1 & Serializable)spec -> {
                this.validateSpecification((String)spec);
                Definition definition = $this.definitionParser.parse((String)spec);
                Definition updatedDefinition = new Definition(definition.apiVersion(), this.metadataMap(folderId), definition.kind(), definition.spec());
                return $this.creationService.processBlueprint(updatedDefinition, scmData);
            });
            this.markAsApplied(version, config);
        });
    }

    public String generatePreview(String folderId, Option<String> version) {
        return (String)this.wrapExceptions().apply((Function0 & Serializable)() -> {
            ScmBlobs scmBlobs;
            FolderVersioningSettings config = this.getSettings(folderId);
            String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                AsCodeJGitConnector scmConnector = this.initConnector(config);
                scmBlobs = (ScmBlobs)scmConnector.checkout(filePath, ver, false).get();
            } else if (None$.MODULE$.equals(option)) {
                scmBlobs = (ScmBlobs)this.generateFolder(folderId, config, filePath)._1();
            } else {
                throw new MatchError((Object)option);
            }
            ScmBlobs blobs = scmBlobs;
            return new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public AsCodeJGitConnector initConnector(FolderVersioningSettings config) {
        Repository connectorConfig = config.gitConnection();
        this.configurationVariableService.resolve((Configuration)connectorConfig);
        return new AsCodeJGitConnector(config);
    }

    private Tuple2<ScmBlobs, List<Definition>> generateFolder(String folderId, FolderVersioningSettings config, String filePath) {
        Tuple2 tuple2;
        boolean x$1 = config.exportConfiguration();
        boolean x$2 = config.exportDashboards();
        boolean x$3 = config.exportTemplates();
        boolean x$4 = config.exportTriggers();
        boolean x$5 = config.exportVariables();
        boolean x$6 = config.exportPatterns();
        boolean x$7 = config.exportNotifications();
        boolean x$8 = config.exportSecurity();
        boolean x$9 = GenerateService$CisConfig$.MODULE$.apply$default$2();
        boolean x$10 = GenerateService$CisConfig$.MODULE$.apply$default$3();
        boolean x$11 = GenerateService$CisConfig$.MODULE$.apply$default$4();
        boolean x$12 = GenerateService$CisConfig$.MODULE$.apply$default$5();
        boolean x$13 = GenerateService$CisConfig$.MODULE$.apply$default$6();
        boolean x$14 = GenerateService$CisConfig$.MODULE$.apply$default$12();
        boolean x$15 = GenerateService$CisConfig$.MODULE$.apply$default$13();
        boolean x$16 = GenerateService$CisConfig$.MODULE$.apply$default$16();
        boolean x$17 = GenerateService$CisConfig$.MODULE$.apply$default$17();
        GenerateService.CisConfig cisConfig = new GenerateService.CisConfig(x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$4, x$6, x$2, x$1, x$14, x$15, x$5, x$7, x$16, x$17);
        try {
            FolderSearch scope = FolderSearch$.MODULE$.apply(this.folderAsCodeService.getFolderPath(folderId), folderId, true);
            List<Definition> definitions = this.generateService.generate(new GenerateService.GeneratorConfig((Option<String>)None$.MODULE$, scope, cisConfig, GenerateService$GeneratorConfig$.MODULE$.apply$default$4()));
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XLRDefinitionWriter qual$1 = XLRDefinitionWriter$.MODULE$.apply();
            ByteArrayOutputStream x$18 = stream;
            DefinitionWriter.WriterConfig x$19 = new DefinitionWriter.WriterConfig(definitions, false, false);
            boolean x$20 = qual$1.writeYaml$default$3();
            qual$1.writeYaml(x$18, x$19, x$20);
            tuple2 = new Tuple2((Object)new ScmBlobs((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BinaryFile[]{new BinaryFile(filePath, (Function0 & Serializable)() -> stream.toByteArray())}))), definitions);
        }
        catch (AsCodeException e) {
            throw new ScmException(e.getMessage(), e.getCause(), ScmException$.MODULE$.apply$default$3());
        }
        return tuple2;
    }

    private void validateSettings(FolderVersioningSettings config) {
        block0: {
            AsCodeJGitConnector connector = this.initConnector(config);
            String url = connector.getConnectionSettings().getUrl();
            if (JGitConnector$.MODULE$.isFileRepo(url)) break block0;
            JGitConnector$.MODULE$.verifyRepositoryPath(url);
            JGitConnector$.MODULE$.verifyRemoteBranch(url, config.branch());
        }
    }

    private void validateSpecification(String spec) {
        Regex taggedValueRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(":\\s*!value\\b"));
        if (taggedValueRegex.findFirstMatchIn((CharSequence)spec).isDefined()) {
            throw new ScmException("Unable to apply: '!value' tags in passwords not supported. Use variables for passwords", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    private Option<Map<String, String>> metadataMap(String folderId) {
        return new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.FOLDER().toString()), (Object)folderId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString()), (Object)this.folderAsCodeService.getFolderPath(folderId))})));
    }

    private Seq<String> extractSpecs(ScmBlobs blobs) {
        Regex SPEC_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\Rspec:"));
        String content = new String((byte[])((BinaryFile)blobs.files().head()).getContent().apply(), StandardCharsets.UTF_8);
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])content.split("\\R---")), (Function1 & Serializable)x$4 -> x$4.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$extractSpecs$2(SPEC_REGEX, spec)))));
    }

    private void markAsApplied(String version, FolderVersioningSettings config) {
        Date now = new Date();
        config.lastFetched_$eq(now);
        config.appliedVersion_$eq(version);
        config.appliedDate_$eq(now);
        config.appliedBy_$eq(Permissions.getAuthenticatedUserName());
        this.configurationRepository.update((BaseConfiguration)config);
    }

    private void applyScmDataToDefinitions(Seq<Definition> definitions, SCMTraceabilityData scmData) {
        Seq foldersAndCis = (Seq)definitions.withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningService.$anonfun$applyScmDataToDefinitions$2(x$5))).flatMap((Function1 & Serializable)x$6 -> ((CiSpec)x$6.spec()).cis());
        Seq justCis = FolderVersioningService.flattenCis$1(foldersAndCis);
        justCis.foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            ConfigurationItem configurationItem = x0$1;
            if (configurationItem instanceof Release) {
                Release release = (Release)configurationItem;
                boxedUnit = $this.releaseService.createSCMData(release.getId(), scmData);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private SCMTraceabilityData getScmTraceabilityData(FolderVersioningSettings config, VersionInfo versionInfo) {
        return new SCMTraceabilityData("git", String.valueOf(versionInfo.commitHash()), versionInfo.author(), new DateTime((Object)versionInfo.commitTime()), new StringBuilder(3).append("[").append(versionInfo.name()).append("] ").append(versionInfo.shortMessage()).toString(), config.gitConnection().getUrl(), FolderVersioningSettings$.MODULE$.getDefinitionsPath(config));
    }

    public static final /* synthetic */ boolean $anonfun$extractSpecs$2(Regex SPEC_REGEX$1, String spec) {
        return !spec.isBlank() && SPEC_REGEX$1.findFirstIn((CharSequence)spec).isDefined();
    }

    private static final Seq flattenCis$1(Seq cis) {
        return (Seq)cis.flatMap((Function1 & Serializable)x0$1 -> {
            Seq seq;
            ConfigurationItem configurationItem = x0$1;
            if (configurationItem instanceof Folder) {
                Folder folder = (Folder)configurationItem;
                seq = FolderVersioningService.flattenCis$1(CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toSeq());
            } else {
                seq = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigurationItem[]{configurationItem}));
            }
            return seq;
        });
    }

    public static final /* synthetic */ boolean $anonfun$applyScmDataToDefinitions$2(Definition x$5) {
        return x$5.spec() instanceof CiSpec;
    }

    @Autowired
    public FolderVersioningService(UserProfileService userProfileService, GenerateService generateService, CreationService creationService, XLRDefinitionParser definitionParser, ConfigurationRepository configurationRepository, ConfigurationVariableService configurationVariableService, ConfigurationService configurationService, FolderAsCodeService folderAsCodeService, ReleaseService releaseService, CiIdService ciIdService) {
        this.userProfileService = userProfileService;
        this.generateService = generateService;
        this.creationService = creationService;
        this.definitionParser = definitionParser;
        this.configurationRepository = configurationRepository;
        this.configurationVariableService = configurationVariableService;
        this.configurationService = configurationService;
        this.folderAsCodeService = folderAsCodeService;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        Logging.$init$((Logging)this);
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

