/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.ImportResult$;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.service.spec.CiSpecInterpreter;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0015\t\b\u0001\"\u0003s\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!!\u0010\u0001\t\u0013\tyD\u0001\u000eD_:4\u0017nZ;sCRLwN\\!t\u0007>$WmU3sm&\u001cWM\u0003\u0002\u000e\u001d\u000591/\u001a:wS\u000e,'BA\b\u0011\u0003\u0019\t7oY8eK*\u0011\u0011CE\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nQa\u001d7gi)T\u0011aI\u0001\tOJL'P\u001f7fI&\u0011Q\u0005\t\u0002\b\u0019><w-\u001b8h\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005!RS\"A\u0015\u000b\u00055\u0001\u0012BA\u0016*\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0011\u0003)\u0011X\r]8tSR|'/_\u0005\u0003e=\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002\u001fI,g-\u001a:f]\u000e,7k\u001c7wKJ\u0004\"!\u000e\u001c\u000e\u00031I!a\u000e\u0007\u0003\u001fI+g-\u001a:f]\u000e,7k\u001c7wKJ\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003uuj\u0011a\u000f\u0006\u0003yA\ta!\u001a<f]R\u001c\u0018B\u0001 <\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u00135\tR#\u0011\u0005U\u0002\u0001\"\u0002\u0014\u0006\u0001\u00049\u0003\"\u0002\u0017\u0006\u0001\u0004i\u0003\"B\u001a\u0006\u0001\u0004!\u0004\"\u0002\u001d\u0006\u0001\u0004I\u0004FA\u0003H!\tA5+D\u0001J\u0015\tQ5*\u0001\u0006b]:|G/\u0019;j_:T!\u0001T'\u0002\u000f\u0019\f7\r^8ss*\u0011ajT\u0001\u0006E\u0016\fgn\u001d\u0006\u0003!F\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002%\u0006\u0019qN]4\n\u0005QK%!C!vi><\u0018N]3e\u0003\u001d\u0001(o\\2fgN$2a\u0016.c!\t)\u0004,\u0003\u0002Z\u0019\ta\u0011*\u001c9peR\u0014Vm];mi\")1L\u0002a\u00019\u000691m\u001c8uKb$\bCA/a\u001b\u0005q&BA0\u000f\u0003\u0015)H/\u001b7t\u0013\t\tgLA\u0007J[B|'\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0006G\u001a\u0001\r\u0001Z\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\u0004\u0012A\u00023p[\u0006Lg.\u0003\u0002jM\ni1i\u001c8gS\u001e,(/\u0019;j_:\fAAZ5oIR\u0019An\u001c9\u0011\u0007eiG-\u0003\u0002o5\t1q\n\u001d;j_:DQaW\u0004A\u0002qCQaY\u0004A\u0002\u0011\fQ\u0003]8qk2\fG/Z\"p]\u001aLw-\u001e:bi&|g\u000eF\u0004tm^\fI!a\f\u0011\u0005e!\u0018BA;\u001b\u0005\u0011)f.\u001b;\t\u000b\rD\u0001\u0019\u00013\t\u000baD\u0001\u0019A=\u0002\u0005%$\u0007c\u0001>\u0002\u00049\u00111p \t\u0003yji\u0011! \u0006\u0003}Z\ta\u0001\u0010:p_Rt\u0014bAA\u00015\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001\u001b\u0011\u001d\tY\u0001\u0003a\u0001\u0003\u001b\t!B]3gKJ,gnY3t!\u0019\ty!!\u0007\u0002 9!\u0011\u0011CA\u000b\u001d\ra\u00181C\u0005\u00027%\u0019\u0011q\u0003\u000e\u0002\u000fA\f7m[1hK&!\u00111DA\u000f\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005]!\u0004\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u001bM,'/[1mSj\fG/[8o\u0015\r\tICE\u0001\u0007q2$\u0018\u0010]3\n\t\u00055\u00121\u0005\u0002\f\u0007&\u0014VMZ3sK:\u001cW\rC\u0004\u00022!\u0001\r!a\r\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\u00042!G7z\u0003\u0019\u0019'/Z1uKR)A-!\u000f\u0002<!)1,\u0003a\u00019\")1-\u0003a\u0001I\u00061Q\u000f\u001d3bi\u0016$r\u0001ZA!\u0003\u0007\n9\u0005C\u0003\\\u0015\u0001\u0007A\f\u0003\u0004\u0002F)\u0001\r\u0001Z\u0001\tKbL7\u000f^5oO\")1M\u0003a\u0001I\"\u001a\u0001!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015P\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003+\nyEA\u0004TKJ4\u0018nY3")
public class ConfigurationAsCodeService
implements Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final ReferenceSolver referenceSolver;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationAsCodeService configurationAsCodeService = this;
        synchronized (configurationAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Configuration configuration) {
        CiSpecInterpreter.ProcessedCi<Configuration> processedCi;
        Map<String, String> metadata = context.metadata();
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(40).append("Processing configuration ").append(configuration.toString()).append(" with metadata ").append(metadata.toString()).toString());
        Option<Configuration> option = this.find(context, configuration);
        if (option instanceof Some) {
            Some some = (Some)option;
            Configuration existing = (Configuration)some.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Updating configuration: ").append(existing.toString()).toString());
            Configuration updated = this.update(context, existing, configuration);
            processedCi = new CiSpecInterpreter.ProcessedCi<Configuration>(updated, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent((BaseConfiguration)updated))}))));
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Creating configuration: ").append(configuration.toString()).toString());
            Configuration created = this.create(context, configuration);
            processedCi = new CiSpecInterpreter.ProcessedCi<Configuration>(created, AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (Seq<PostCommitAction>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent((BaseConfiguration)created))}))));
        } else {
            throw new MatchError(option);
        }
        CiSpecInterpreter.ProcessedCi<Configuration> processed = processedCi;
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{processed.changedIds()}))), processed.postCommitActions(), ImportResult$.MODULE$.apply$default$3());
    }

    private Option<Configuration> find(ImportContext context, Configuration configuration) {
        Option<String> folderId = context.scope().getFolderId();
        String title = configuration.getTitle();
        List matches = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByTypeAndTitle(configuration.getType(), title, (String)folderId.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), folderId.isDefined())).asScala().toList();
        if (matches.length() > 1) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(67).append("There are multiple configurations of type [").append(configuration.getType()).append("] named [").append(title).append("] ").append(context.scope().description()).append(", those are: ").append(matches.toString()).toString());
            throw new AsCodeException(new StringBuilder(88).append("Multiple configurations of type [").append(configuration.getType()).append("] are named [").append(title).append("] ").append(context.scope().description()).append(". Can not determine which one to update.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return matches.headOption();
    }

    private void populateConfiguration(Configuration configuration, String id, List<CiReference> references, Option<String> folderId) {
        configuration.setId(id);
        configuration.setFolderId((String)folderId.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.referenceSolver.resolveReferences((ConfigurationItem)configuration, references, (String)folderId.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        CiHelper.fixUpInternalReferences((ConfigurationItem)configuration);
    }

    private Configuration create(ImportContext context, Configuration configuration) {
        String id = this.ciIdService.getUniqueId(Type.valueOf(Configuration.class), Ids.CUSTOM_CONFIGURATION_ROOT);
        this.populateConfiguration(configuration, id, context.references(), context.scope().getFolderId());
        return (Configuration)this.configurationRepository.create((BaseConfiguration)configuration, (Integer)context.scope().getFolderCiUid().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Configuration update(ImportContext context, Configuration existing, Configuration configuration) {
        this.populateConfiguration(configuration, existing.getId(), context.references(), context.scope().getFolderId());
        return (Configuration)this.configurationRepository.update((BaseConfiguration)configuration, (Integer)context.scope().getFolderCiUid().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Autowired
    public ConfigurationAsCodeService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ReferenceSolver referenceSolver, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.referenceSolver = referenceSolver;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

