/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\u0007\u000e\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00034\u0001\u0011\u0005A\u0007C\u0004;\u0001\t\u0007I\u0011B\u001e\t\r!\u0003\u0001\u0015!\u0003=\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015\t\b\u0001\"\u0001s\u0005u1u\u000e\u001c3feZ+'o]5p]&twmQ8oM&<7+\u001a:wS\u000e,'B\u0001\b\u0010\u0003\r\u00198-\u001c\u0006\u0003!E\ta!Y:d_\u0012,'B\u0001\n\u0014\u0003)1XM]:j_:Lgn\u001a\u0006\u0003)U\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006Y1-[%e'\u0016\u0014h/[2f!\t\u0019c%D\u0001%\u0015\t)3#A\u0004tKJ4\u0018nY3\n\u0005\u001d\"#aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011af\u000b\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\fAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0007CA\u00122\u0013\t\u0011DE\u0001\u000bD_:4\u0017nZ;sCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU:\u0004(\u000f\t\u0003m\u0001i\u0011!\u0004\u0005\u0006C\u0011\u0001\rA\t\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\u0006_\u0011\u0001\r\u0001M\u0001\u0007G&$\u0016\u0010]3\u0016\u0003q\u0002\"!\u0010$\u000e\u0003yR!a\u0010!\u0002\u000fI,g\r\\3di*\u0011\u0011IQ\u0001\u0004CBL'BA\"E\u0003\u0019\u0001H.^4j]*\u0011Q)F\u0001\tI\u0016\u0004Hn\\=ji&\u0011qI\u0010\u0002\u0005)f\u0004X-A\u0004dSRK\b/\u001a\u0011\u0002-\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKN+G\u000f^5oON$\"aS*\u0011\u00051\u000bV\"A'\u000b\u0005Aq%B\u0001\nP\u0015\t\u00016#\u0001\u0004e_6\f\u0017N\\\u0005\u0003%6\u0013\u0001DR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKR$\u0018N\\4t\u0011\u0015!v\u00011\u0001L\u0003%qWm^\"p]\u001aLw-\u0001\beK2,G/Z*fiRLgnZ:\u0015\u0005]S\u0006C\u0001\u000fY\u0013\tIVD\u0001\u0003V]&$\b\"B.\t\u0001\u0004a\u0016\u0001\u00034pY\u0012,'/\u00133\u0011\u0005u#gB\u00010c!\tyV$D\u0001a\u0015\t\t\u0017$\u0001\u0004=e>|GOP\u0005\u0003Gv\ta\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111-H\u0001\rM&tGmU3ui&twm\u001d\u000b\u0003S2\u00042\u0001\b6L\u0013\tYWD\u0001\u0004PaRLwN\u001c\u0005\u00067&\u0001\r\u0001X\u0001\u0017kB$\u0017\r^3TKR$\u0018N\\4t\t&\u0014Xm\u0019;msR\u00111j\u001c\u0005\u0006a*\u0001\raS\u0001\u0007G>tg-[4\u0002%Y\fG.\u001b3bi\u0016\u001cuN\u001c4jO\u0012\u000bG/\u0019\u000b\u0004/N$\b\"\u00029\f\u0001\u0004Y\u0005\"B;\f\u0001\u0004a\u0016a\u00034pY\u0012,'\u000fV5uY\u0016D#\u0001A<\u0011\u0005a|X\"A=\u000b\u0005i\\\u0018AC:uKJ,w\u000e^=qK*\u0011A0`\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta0A\u0002pe\u001eL1!!\u0001z\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class FolderVersioningConfigService {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationService configurationService;
    private final Type ciType;

    private Type ciType() {
        return this.ciType;
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig) {
        FolderVersioningSettings folderVersioningSettings;
        Option<FolderVersioningSettings> option = this.findSettings(newConfig.getFolderId());
        if (option instanceof Some) {
            Some some = (Some)option;
            FolderVersioningSettings existingConfig = (FolderVersioningSettings)((Object)some.value());
            existingConfig.updateWith(newConfig);
            folderVersioningSettings = existingConfig;
        } else if (None$.MODULE$.equals(option)) {
            newConfig.setId(this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_ID_ROOT()));
            folderVersioningSettings = newConfig;
        } else {
            throw new MatchError(option);
        }
        FolderVersioningSettings config = folderVersioningSettings;
        this.configurationService.createOrUpdate((BaseConfiguration)config);
        return config;
    }

    public void deleteSettings(String folderId) {
        Option<FolderVersioningSettings> option = this.findSettings(folderId);
        if (option instanceof Some) {
            Some some = (Some)option;
            FolderVersioningSettings config = (FolderVersioningSettings)((Object)some.value());
            this.configurationRepository.delete(config.getId());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption();
    }

    public FolderVersioningSettings updateSettingsDirectly(FolderVersioningSettings config) {
        return (FolderVersioningSettings)this.configurationRepository.update((BaseConfiguration)config);
    }

    public void validateConfigData(FolderVersioningSettings config, String folderTitle) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)config.scmPath()), (String)new StringBuilder(80).append("Can't create version control configurations for folder ").append(folderTitle).append(", scmPath cannot be blank").toString(), (Object[])new Object[0]);
    }

    public FolderVersioningConfigService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ConfigurationService configurationService) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

