package com.xebialabs.xlrelease.ascode.yaml.sugar

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.ascode.yaml.sugar.GenerateStrategy.Skip
import com.xebialabs.ascode.yaml.sugar.SugarConfig.{descriptor, descriptorFromType}
import com.xebialabs.ascode.yaml.sugar.{Add, Change, Remove, SugarConfig}
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getSubtypes
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlplatform.webhooks.domain.RequestAuthentication
import com.xebialabs.xlrelease.ascode.yaml.model.{CalendarAsCode, EmailNotificationSettingsAsCode, NotificationTriggerSettingsAsCode, ReleaseCalendar}
import com.xebialabs.xlrelease.configuration._
import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.domain.calendar.{Blackout, SpecialDay}
import com.xebialabs.xlrelease.domain.delivery.{Condition, Delivery, Stage, TrackedItem}
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.domain.scm.connector.ScmCredential
import com.xebialabs.xlrelease.domain.variables._
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.notifications.configuration.{OAuth2SmtpAuthentication, SmtpAuthentication, SmtpServer}
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import com.xebialabs.xlrelease.reports.filters.ReportFilter
import com.xebialabs.xlrelease.triggers.event_based.{EventBasedTrigger, EventFilter, EventFilterExpressionItem}
import com.xebialabs.xlrelease.udm.reporting.DeploymentTaskFacet
import com.xebialabs.xlrelease.udm.reporting.filters.impl.{FolderFilter, TemplateFilter}
import com.xebialabs.xlrelease.udm.reporting.filters.{ApplicationFilter, EnvironmentFilter, EnvironmentLabelFilter, EnvironmentStageFilter}
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings
import com.xebialabs.xlrelease.webhooks.authentication.BaseRequestAuthentication
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty
import org.springframework.util.StringUtils

import scala.jdk.CollectionConverters._
import scala.reflect.ClassTag

object XLRSugar {
  implicit val config: SugarConfig = SugarConfig(Seq(
    descriptor[ConfigurationItem](blacklistedFields = Set("title"), generateIdField = Some("title")),
    descriptor[PlanItem](blacklistedFields = Set("status")),
    descriptor[Release](
      key = Some("template"),
      blacklistedFields = Set(
        "id",
        "flagStatus",
        "maxConcurrentReleases",
        "overdueNotified",
        "queryableStartDate",
        "queryableEndDate",
        "teams",
        "attachments"
      )
    ),
    descriptor[Task](blacklistedFields = Set("pythonScript", "comments", "attachments")),
    descriptor[Team](blacklistedFields = Set("name"), generateIdField = Some("teamName")),
    descriptor[Configuration](blacklistedFields = Set("folderId")),
    globalOrFolderVariableDescriptor[FolderVariables],
    globalOrFolderVariableDescriptor[GlobalVariables],
    descriptor[Dependency](blacklistedFields = Set("target", "name"), deSugarActions = List(Change("target", "targetId"))),
    descriptor[Folder]("directory"),
    descriptor[PythonScript](generateStrategy = Skip),
    descriptor[Variable](blacklistedFields = Set("name", "folderId"), generateIdField = Some("key")),
    descriptor[Dashboard](blacklistedFields = Set("parentId"), deSugarActions = List(Change("parentTemplate", "parentId"))),
    descriptor[Phase]("phase"),
    descriptor[Delivery](key = Some("pattern"), blacklistedFields = Set("status", "folderId", "startDate", "endDate")),
    descriptor[Stage]("stage"),
    descriptor[Condition](blacklistedFields = Set("name")),
    descriptor[TrackedItem](key = Some("trackedItem"), blacklistedFields = Set("createdDate", "modifiedDate")),
    descriptor[ValueProviderConfiguration](blacklistedFields = Set("name")),
    descriptor[ExternalVariableValue](blacklistedFields = Set("name")),
    descriptor[ScmCredential](blacklistedFields = Set("name")),
    descriptor[DeploymentTaskFacet](key = None, sugarActions = List(Change("applicationId", "application"), Change("environmentId", "environment")), deSugarActions = List(Change("application", "applicationId"), Change("environment", "environmentId")), blacklistedFields = Set("targetId", "name", "id")),
    descriptor[CreateReleaseTask](deSugarActions = List(Change("template", "templateId"), Change("folder", "folderId")), sugarActions = List(Change("templateId", "template"), Change("folderId", "folder"))),
    descriptor[ReportFilter](blacklistedFields = Set("name", "title")),
    descriptor[FolderFilter](sugarActions = List(Change("folderId", "folder")), deSugarActions = List(Change("folder", "folderId"))),
    descriptor[TemplateFilter](sugarActions = List(Change("templateId", "template")), deSugarActions = List(Change("template", "templateId"))),
    descriptor[EnvironmentStageFilter](blacklistedFields = Set("name"), deSugarActions = List(Change("stage", "environmentStageId")), sugarActions = List(Change("environmentStageId", "stage"))),
    descriptor[EnvironmentFilter](blacklistedFields = Set("name"), deSugarActions = List(Change("environment", "environmentId")), sugarActions = List(Change("environmentId", "environment"))),
    descriptor[EnvironmentLabelFilter](blacklistedFields = Set("name"), deSugarActions = List(Change("label", "environmentLabelId")), sugarActions = List(Change("environmentLabelId", "label"))),
    descriptor[ApplicationFilter](blacklistedFields = Set("name"), deSugarActions = List(Change("application", "applicationId")), sugarActions = List(Change("applicationId", "application"))),
    descriptorFromType(ciType = typeOf("xlrelease.DeploymentsByStageDashboard"), blacklistedFields = Set("stageIds")),
    descriptor[MappedProperty](blacklistedFields = Set("name")),
    descriptor[EventFilter](blacklistedFields = Set("name")),
    descriptor[EventFilterExpressionItem](blacklistedFields = Set("name")),
    descriptor[RequestAuthentication](blacklistedFields = Set("name")),
    descriptor[BaseRequestAuthentication](blacklistedFields = Set("name")),
    descriptor[ReleaseTrigger](whitelistedFields = Set("tags", "template", "variables", "releaseFolder")),
    descriptor[EventBasedTrigger](whitelistedFields = Set("mappedProperties", "triggerActionType")),
    // general settings sugar
    settingsDescriptor[TemplateVersioningSettings],
    settingsDescriptor[ThemeSettings],
    settingsDescriptor[ExecutionLogPurgeSettings],
    settingsDescriptor[TriggerDataPurgeSettings],
    settingsDescriptor[ReportsSettings],
    settingsDescriptor[PollingSettings],
    settingsDescriptor[ArchivingSettings],
    settingsDescriptor[AuditReportSettings],
    settingsDescriptor[SmtpServer],
    descriptor[SmtpAuthentication](blacklistedFields = Set("name")),
    descriptor[OAuth2SmtpAuthentication](blacklistedFields = Set("name", "accessToken", "expiresAt")),
    descriptor[EmailNotificationSettingsAsCode](
      key = Some("notifications"),
      blacklistedFields = Set("name"),
      sugarActions = List(Remove("type")),
      deSugarActions = List(Add("type", typeOf[EmailNotificationSettingsAsCode].toString))
    ),
    descriptor[NotificationTriggerSettingsAsCode](
      key = Some("notification"),
      blacklistedFields = Set("name"),
      sugarActions = List(Remove("type")),
      deSugarActions = List(Add("type", typeOf[NotificationTriggerSettingsAsCode].toString))
    ),
    descriptor[CalendarAsCode](
      key = Some("calendar"),
      blacklistedFields = Set("name"),
      sugarActions = List(Remove("type")),
      deSugarActions = List(Add("type", typeOf[CalendarAsCode].toString))
    ),
    descriptor[ReleaseCalendar](
      blacklistedFields = Set("name")
    ),
    descriptor[Blackout](
      blacklistedFields = Set("name")
    ),
    descriptor[SpecialDay](
      blacklistedFields = Set("name")
    ),
    descriptor[Link](
      blacklistedFields = Set("name")
    ),
    descriptor[FolderVersioningSettings](blacklistedFields = Set("folderId", "name"), deSugarActions = List(Remove("tagPrefix")))
  ) ++ getSubtypes(typeOf("delivery.Task")).asScala.map(ciType => descriptorFromType(ciType = ciType,
    sugarActions = List(Change("deliveryId", "delivery"), Change("patternId", "pattern"), Change("folderId", "folder")),
    deSugarActions = List(Change("delivery", "deliveryId"), Change("pattern", "patternId"), Change("folder", "folderId")))): _*
  )

  private def globalOrFolderVariableDescriptor[T <: ConfigurationItem : ClassTag] = {
    val tpe = Type.valueOf(implicitly[ClassTag[T]].runtimeClass)
    val typeName = StringUtils.uncapitalize(tpe.getName)
    descriptor[T](
      key = Some(typeName),
      blacklistedFields = Set("name"),
      deSugarActions = List(Change(typeName, "variables"), Add("type", tpe.toString)),
      sugarActions = List(Change("variables", typeName), Remove("type"))
    )
  }

  private def settingsDescriptor[T <: BaseConfiguration : ClassTag] = {
    descriptor[T](
      blacklistedFields = Set("name")
    )
  }
}
