package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlrelease.ascode.service.validator.SpecValidator
import com.xebialabs.xlrelease.ascode.utils.Utils
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util
import scala.jdk.CollectionConverters._

@Service
@Autowired
class CreationService(specInterpreters: util.List[SpecInterpreter],
                      specValidators: util.List[SpecValidator]) extends Logging {
  private val interpret = SpecInterpreter.compose(specInterpreters.asScala)
  private val validate = SpecValidator.compose(specValidators.asScala)

  def processBlueprint(definition: Definition, scmData: SCMTraceabilityData = new SCMTraceabilityData()): AsCodeResponse = {
    validate(definition)
    val filteredSCMData = if (Utils.isSCMDataEmpty(scmData)) None else Option(scmData)
    interpret(InterpreterContext(definition, filteredSCMData))
  }
}
