package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.CreateReleaseTaskStringReferenceCreationHandler._
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.domain.CreateReleaseTask
import com.xebialabs.xlrelease.service.ReleaseService
import com.xebialabs.xlrelease.variable.VariableHelper
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

object CreateReleaseTaskStringReferenceCreationHandler {
  val folderIdField = "folderId"
  val templateIdField = "templateId"

  def templateIdDescriptor: PropertyDescriptor = typeOf[CreateReleaseTask].getDescriptor.getPropertyDescriptor(templateIdField)

  def folderIdDescriptor: PropertyDescriptor = typeOf[CreateReleaseTask].getDescriptor.getPropertyDescriptor(folderIdField)

  val properties: Set[String] = Set(
    folderIdField,
    templateIdField
  )
}

@Component
class CreateReleaseTaskStringReferenceCreationHandler @Autowired()(releaseService: ReleaseService, folderAsCodeService: FolderAsCodeService)
  extends StringReferenceCreationHandler {

  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = {
    config.ci.isInstanceOf[CreateReleaseTask] &&
      (templateIdDescriptor.get(config.ci) != null || folderIdDescriptor.get(config.ci) != null)
  }

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val templateId = Option(templateIdDescriptor.get(config.ci)) match {
      case Some(templatePath: String) if !VariableHelper.containsVariables(templatePath) =>
        val pathAndTitle = Utils.parseAbsolutePath(templatePath).replaceRelativePath(config.home)

        val value = config.templateIds.get(pathAndTitle.absolutePath()) match {
          case Some(id) => Some(id)
          case None => {
            val folderId = pathAndTitle.folderPath.map(folderAsCodeService.searchFolder(_)).flatten.map(_.getId).orNull
            releaseService
              .findTemplatesByTitle(folderId, pathAndTitle.title, 0, 2, 1)
              .asScala
              .headOption
              .map(_.getId)
          }
        }
        Map(templateIdDescriptor -> value)
      case _ => Map.empty
    }

    val folderId = Option(folderIdDescriptor.get(config.ci)) match {
      case Some(folderPath: String) if !VariableHelper.containsVariables(folderPath) =>
        folderAsCodeService.searchFolder(FolderAsCodeService.absolutePath(folderPath, config.home)) match {
          case Some(folder) => Map(folderIdDescriptor -> Some(folder.getId))
          case None => throw new AsCodeException(s"Cannot find folder with name [${folderIdDescriptor.get(config.ci).asInstanceOf[String]}] should be created first before trying to use it.")
        }
      case _ => Map.empty
    }

    StringReferenceContainer(config.ci, (templateId ++ folderId).toMap)
  }
}
