/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.ascode.yaml.model.ImportsSpec;
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningConfigService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService$;
import com.xebialabs.xlrelease.versioning.ascode.scm.YamlUtils$;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnectorInitializer;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStyleResolver;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001\u0002\b\u0010\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001da\u0007!%A\u0005\u00025DQa\u001e\u0001\u0005\naDq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0002\u001f\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u0004&/\u001a<jK^\u001cVM\u001d<jG\u0016T!\u0001E\t\u0002\u0007M\u001cWN\u0003\u0002\u0013'\u00051\u0011m]2pI\u0016T!\u0001F\u000b\u0002\u0015Y,'o]5p]&twM\u0003\u0002\u0017/\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003Q\u0019wN\u001c8fGR|'/\u00138ji&\fG.\u001b>feB\u0011Q\u0005K\u0007\u0002M)\u0011qeD\u0001\nG>tg.Z2u_JL!!\u000b\u0014\u0003=\u0005\u001b8i\u001c3f\u0015\u001eKGoQ8o]\u0016\u001cGo\u001c:J]&$\u0018.\u00197ju\u0016\u0014\u0018!\b4pY\u0012,'OV3sg&|g.\u001b8h\u0007>tg-[4TKJ4\u0018nY3\u0011\u00051jS\"A\b\n\u00059z!!\b$pY\u0012,'OV3sg&|g.\u001b8h\u0007>tg-[4TKJ4\u0018nY3\u0002/Y,'o]5p]&twm\u0015;zY\u0016\u0014Vm]8mm\u0016\u0014\bCA\u00195\u001b\u0005\u0011$BA\u001a\u0010\u0003!\u0019HO]1uK\u001eL\u0018BA\u001b3\u0005]1VM]:j_:LgnZ*us2,'+Z:pYZ,'/\u0001\teK\u001aLg.\u001b;j_:\u0004\u0016M]:feB\u0011\u0001HP\u0007\u0002s)\u0011!hO\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005qj\u0014\u0001B=b[2T!AE\u000b\n\u0005}J$a\u0005-M%\u0012+g-\u001b8ji&|g\u000eU1sg\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003C\u0007\u0012+e\t\u0005\u0002-\u0001!)1%\u0002a\u0001I!)!&\u0002a\u0001W!)q&\u0002a\u0001a!)a'\u0002a\u0001o!\u0012Q\u0001\u0013\t\u0003\u0013Rk\u0011A\u0013\u0006\u0003\u00172\u000b!\"\u00198o_R\fG/[8o\u0015\tie*A\u0004gC\u000e$xN]=\u000b\u0005=\u0003\u0016!\u00022fC:\u001c(BA)S\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A*\u0002\u0007=\u0014x-\u0003\u0002V\u0015\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0010O\u0016tWM]1uKB\u0013XM^5foR!\u0001lY3k!\tI\u0006M\u0004\u0002[=B\u00111lH\u0007\u00029*\u0011QlG\u0001\u0007yI|w\u000e\u001e \n\u0005}{\u0012A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!aX\u0010\t\u000b\u00114\u0001\u0019\u0001-\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012DQA\u001a\u0004A\u0002\u001d\fqA^3sg&|g\u000eE\u0002\u001fQbK!![\u0010\u0003\r=\u0003H/[8o\u0011\u001dYg\u0001%AA\u0002a\u000b\u0001BZ5mK:\u000bW.Z\u0001\u001aO\u0016tWM]1uKB\u0013XM^5fo\u0012\"WMZ1vYR$3'F\u0001oU\tAvnK\u0001q!\t\tX/D\u0001s\u0015\t\u0019H/A\u0005v]\u000eDWmY6fI*\u00111jH\u0005\u0003mJ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y9WM\\3sCR,g+\u001a:tS>t\u0007K]3wS\u0016<H\u0003C=\u0000\u0003\u0003\t)\"a\b\u0011\u0005ilX\"A>\u000b\u0005\u001db(B\u0001\t\u0016\u0013\tq8P\u0001\u0006CS:\f'/\u001f$jY\u0016DQa\u001b\u0005A\u0002aCq!a\u0001\t\u0001\u0004\t)!\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)\u0019!#a\u0003\u000b\u0007Q\tiAC\u0002\u0002\u0010U\ta\u0001Z8nC&t\u0017\u0002BA\n\u0003\u0013\u0011\u0001DR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKR$\u0018N\\4t\u0011\u001d\t9\u0002\u0003a\u0001\u00033\tqBZ5mKN$vn\u00115fG.|W\u000f\u001e\t\u0005=\u0005m\u0001,C\u0002\u0002\u001e}\u0011Q!\u0011:sCfDa!!\t\t\u0001\u0004A\u0016a\u0001<fe\u0006Qr-\u001a8fe\u0006$X-\u00168wKJ\u001c\u0018n\u001c8fIB\u0013XM^5foR9\u00110a\n\u0002*\u0005-\u0002\"\u00023\n\u0001\u0004A\u0006\"B6\n\u0001\u0004A\u0006bBA\u0002\u0013\u0001\u0007\u0011QA\u0001\u0014O\u0016$h)\u001b7fg\u001a{'o\u00115fG.|W\u000f\u001e\u000b\u0007\u00033\t\t$a\r\t\u000b-T\u0001\u0019\u0001-\t\u000f\u0005\r!\u00021\u0001\u0002\u0006\u0005\u0019b/\u001a:jMf\u0014V-];fgR,GMR5mKRA\u0011\u0011HA \u0003\u0013\nY\u0005E\u0002\u001f\u0003wI1!!\u0010 \u0005\u0011)f.\u001b;\t\u000f\u0005\u00053\u00021\u0001\u0002D\u0005Q1\r[3dW\u0016$w*\u001e;\u0011\u0007i\f)%C\u0002\u0002Hm\u0014\u0001bU2n\u00052|'m\u001d\u0005\u0006W.\u0001\r\u0001\u0017\u0005\b\u0003\u0007Y\u0001\u0019AA\u0003\u0003A9W\r\u001e*fcV,7\u000f^3e\r&dW\rF\u0003z\u0003#\n\u0019\u0006C\u0004\u0002B1\u0001\r!a\u0011\t\u000b-d\u0001\u0019\u0001-\u0002\u0017\u001d,GoU3ui&twm\u001d\u000b\u0005\u0003\u000b\tI\u0006C\u0003e\u001b\u0001\u0007\u0001\fK\u0002\u0001\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0002\u0016AC:uKJ,w\u000e^=qK&!\u0011qMA1\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class FolderVersioningPreviewService {
    private final AsCodeJGitConnectorInitializer connectorInitializer;
    private final FolderVersioningConfigService folderVersioningConfigService;
    private final VersioningStyleResolver versioningStyleResolver;
    private final XLRDefinitionParser definitionParser;

    public String generatePreview(String folderId, Option<String> version, String fileName) {
        return (String)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> {
            BinaryFile binaryFile;
            FolderVersioningSettings config = this.getSettings(folderId);
            String finalFileName = fileName.isEmpty() ? FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME() : fileName;
            String[] filesToCheckout = this.getFilesForCheckout(finalFileName, config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                binaryFile = this.generateVersionPreview(finalFileName, config, filesToCheckout, ver);
            } else if (None$.MODULE$.equals(option)) {
                binaryFile = this.generateUnversionedPreview(folderId, finalFileName, config);
            } else {
                throw new MatchError((Object)option);
            }
            BinaryFile blobs = binaryFile;
            return new String((byte[])blobs.getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public String generatePreview$default$3() {
        return FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME();
    }

    private BinaryFile generateVersionPreview(String fileName, FolderVersioningSettings config, String[] filesToCheckout, String ver) {
        String filenameWithPath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config, fileName);
        return (BinaryFile)Using$.MODULE$.resource((Object)this.connectorInitializer.init(config), (Function1 & Serializable)scmConnector -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> scmConnector.checkout(filesToCheckout, ver, false));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ScmBlobs checkedOut = (ScmBlobs)success.value();
                if (!fileName.equals(FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())) {
                    this.verifyRequestedFile(checkedOut, fileName, config);
                }
                return this.getRequestedFile(checkedOut, filenameWithPath);
            }
            if (try_ instanceof Failure) {
                ScmException scmException;
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (ex instanceof ScmException && (scmException = (ScmException)ex).getMessage().contains("No definition file found for tag")) {
                    throw new NotFoundException(scmException.getMessage(), new Object[0]);
                }
            }
            if (bl) {
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError((Object)try_);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private BinaryFile generateUnversionedPreview(String folderId, String fileName, FolderVersioningSettings config) {
        if (!FolderVersioningSettings$.MODULE$.ALL_FILENAMES().contains((Object)fileName)) {
            throw new NotFoundException("Invalid file requested", new Object[0]);
        }
        String filePath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config, fileName);
        Seq allFiles = this.versioningStyleResolver.resolve(config.versioningStyle()).generateFolder(folderId, config, filePath).blob().files();
        return (BinaryFile)((IterableOps)allFiles.filter((Function1 & Serializable)binaryFile -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$generateUnversionedPreview$1(fileName, binaryFile)))).head();
    }

    private String[] getFilesForCheckout(String fileName, FolderVersioningSettings config) {
        if (fileName.equals(FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())) {
            return (String[])((Object[])new String[]{FolderVersioningSettings$.MODULE$.getDefinitionsPath(config, fileName)});
        }
        return (String[])((Object[])new String[]{FolderVersioningSettings$.MODULE$.getDefinitionsPath(config, fileName), FolderVersioningSettings$.MODULE$.getDefinitionsPath(config, FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())});
    }

    public void verifyRequestedFile(ScmBlobs checkedOut, String fileName, FolderVersioningSettings config) {
        String releasefileName = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config, FolderVersioningSettings$.MODULE$.getDefinitionsPath$default$2());
        BinaryFile releasefile = (BinaryFile)checkedOut.files().find((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$verifyRequestedFile$1(releasefileName, file))).get();
        String releasefileYaml = new String((byte[])releasefile.getContent().apply(), StandardCharsets.UTF_8);
        List<String> specs = YamlUtils$.MODULE$.preprocessYaml(releasefileYaml);
        Definition releasefileDefinition = this.definitionParser.parse((String)specs.head());
        List<String> imports = ((ImportsSpec)releasefileDefinition.spec()).imports();
        if (!imports.contains((Object)fileName)) {
            throw new ScmException("The requested file is not amongst the imports.", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    public BinaryFile getRequestedFile(ScmBlobs checkedOut, String fileName) {
        return (BinaryFile)checkedOut.files().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$getRequestedFile$1(fileName, x$1))).get();
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)$this.folderVersioningConfigService.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("No version control settings defined for folder", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public static final /* synthetic */ boolean $anonfun$generateUnversionedPreview$1(String fileName$3, BinaryFile binaryFile) {
        return FolderVersioningSettings$.MODULE$.getfilename(binaryFile.fileName()).equals(fileName$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRequestedFile$1(String releasefileName$1, BinaryFile file) {
        return file.fileName().equals(releasefileName$1);
    }

    public static final /* synthetic */ boolean $anonfun$getRequestedFile$1(String fileName$4, BinaryFile x$1) {
        return x$1.fileName().equals(fileName$4);
    }

    @Autowired
    public FolderVersioningPreviewService(AsCodeJGitConnectorInitializer connectorInitializer, FolderVersioningConfigService folderVersioningConfigService, VersioningStyleResolver versioningStyleResolver, XLRDefinitionParser definitionParser) {
        this.connectorInitializer = connectorInitializer;
        this.folderVersioningConfigService = folderVersioningConfigService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.definitionParser = definitionParser;
    }
}

