package com.xebialabs.xlrelease.ascode.rest.support

import com.xebialabs.xlrelease.domain.ExportResult
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util.{List => JList}
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}

@Component
@Provider
@Produces(Array("text/vnd.yaml"))
class MultiExportResultYamlWriter extends MessageBodyWriter[JList[ExportResult]] {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[JList[ExportResult]].isAssignableFrom(`type`)

  override def writeTo(results: JList[ExportResult],
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {

    results.forEach(result => {
      entityStream.write(result.yaml.getBytes)
    })
  }
}