package com.xebialabs.xlrelease.ascode.utils

import java.util.{Calendar, Date}
import javax.xml.bind.DatatypeConverter

object DateUtils {

  // Taken from ConfigurationItemConverter
  def toString(date: Date): String = {
    val cal = Calendar.getInstance()
    cal.setTime(date)
    DatatypeConverter.printDateTime(cal)
  }

  def fromString(dateString: String): Date = {
    DatatypeConverter.parseDateTime(dateString).getTime
  }

  private def addToDate(date: Date, amount: Int, typeOfAdd: Int): Date = {
    val calendar = Calendar.getInstance()

    calendar.setTime(date)
    calendar.add(typeOfAdd, amount)

    calendar.getTime
  }

  def addHoursToDate(date: Date, hours: Int): Date = {
    addToDate(date, hours, Calendar.HOUR)
  }

  def addDaysToDate(date: Date, days: Int): Date = {
    addToDate(date, days, Calendar.DAY_OF_MONTH)
  }

  def addWeeksToDate(date: Date, weeks: Int): Date = {
    addToDate(date, weeks, Calendar.WEEK_OF_MONTH)
  }

  def addMonthsToDate(date: Date, months: Int): Date = {
    addToDate(date, months, Calendar.MONTH)
  }

  def secondsToHours(seconds: Int) : Int = seconds / 60 / 60
}
