package com.xebialabs.xlrelease.ascode.service.previewhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.dto.PreviewResponse
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.xlrelease.ascode.utils.StaticVariables

case class PreviewConfig(spec: Spec, metadata: Map[String, String])

object PreviewHandler {
  def compose(handlers: Iterable[PreviewHandler]): PartialFunction[PreviewConfig, PreviewResponse] =
    handlers
      .reduceLeft[PartialFunction[PreviewConfig, PreviewResponse]]((left, right) => left.orElse(right))
      .orElse(new PreviewHandler {
        override def isDefinedAt(x: PreviewConfig): Boolean = true
        override def apply(v1: PreviewConfig): PreviewResponse = throw new AsCodeException(s"Cannot preview this spec. Only [${StaticVariables.XLR_RELEASE_KIND}] spec kind is supported.")
      })
}

trait PreviewHandler extends PartialFunction[PreviewConfig, PreviewResponse]
