package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class CiReferenceGeneratorService @Autowired()(
                                                generators: java.util.List[CiReferenceGeneratorHandler]
                                              ) extends Logging {
  private val handlerFunction = generators.asScala.reduceLeft[PartialFunction[CiWithHome, Unit]]((left, right) => left.orElse(right))
    .orElse(new CiReferenceGeneratorHandler {
      override def isDefinedAt(ciWithHome: CiWithHome): Boolean = false

      override def apply(ciWithHome: CiWithHome): Unit = {}
    })

  def typeSpecificReferenceGenerate(ciWithHome: CiWithHome): Unit = handlerFunction.apply(ciWithHome)
}
