package com.xebialabs.xlrelease.versioning.ascode.upgrader

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.builder.FolderBuilder.newFolder
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.folder.Folder.ROOT_FOLDER_ID
import com.xebialabs.xlrelease.security.sql.snapshots.service.PermissionsSnapshotService
import com.xebialabs.xlrelease.service.{FolderService, SharedConfigurationService, TeamService}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.versioning.ascode.scm.{FolderVersionApplyHelper, FolderVersioningService}
import com.xebialabs.xlrelease.versioning.ascode.upgrader.BaseContentFolderInitializer._
import com.xebialabs.xlrelease.versioning.scheduler.FolderVersioningAutoApplyJobService
import grizzled.slf4j.Logging

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

class XLRelease233WorkflowContentFolderInitializer(folderService: FolderService,
                                                   folderVersioningService: FolderVersioningService,
                                                   folderVersioningAutoApplyJobService: FolderVersioningAutoApplyJobService,
                                                   sharedConfigurationService: SharedConfigurationService,
                                                   permissionSnapshotService: PermissionsSnapshotService,
                                                   teamService: TeamService,
                                                   xlrConfig: XlrConfig)
  extends BaseContentFolderInitializer(folderService, folderVersioningService, folderVersioningAutoApplyJobService, sharedConfigurationService, xlrConfig)
    with FolderVersionApplyHelper with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.3.0#3")

  override def doUpgrade(): Boolean = {
    logger.info("Creating default content folder")

    if (xlrConfig.features.provision.folders.enabled) {
      val daiFolderToCreate = newFolder.withId(DEFAULT_CONTENT_FOLDER_ID).withTitle(xlrConfig.features.provision.folders.defaultContentFolder.folderTitle).build
      val workflowsToCreate = newFolder.withTitle(WORKFLOWS_FOLDER_NAME).build
      val workflowExecutionsToCreate = newFolder.withTitle(WORKFLOW_EXECUTIONS_FOLDER_NAME).build
      Try {
        val daiFolder = folderService.create(ROOT_FOLDER_ID, daiFolderToCreate, createDefaultTeams = false)
        val folderViewerTeam = getFolderViewerTeam()
        teamService.saveTeamsToPlatformWithoutPublishing(daiFolder.getId, folderViewerTeam.asJava, false)

        val workflowsExecutionFolder = folderService.create(daiFolder.getId, workflowExecutionsToCreate, createDefaultTeams = false)
        val workflowAdminTeam = getWorkflowAdminTeam()
        teamService.saveTeamsToPlatformWithoutPublishing(workflowsExecutionFolder.getId, workflowAdminTeam.asJava, false)

        val workflowsFolder = folderService.create(daiFolder.getId, workflowsToCreate, createDefaultTeams = false)

        // create git configuration on root folder
        val gitConfiguration = createGitConfiguration(daiFolder.getId)
        // create folder versioning settings on workflows folder
        createFolderVersioningSettings(workflowsFolder.getId,
          gitConfiguration,
          xlrConfig.features.provision.folders.defaultContentFolder.workflowFolder.scmBranch,
          xlrConfig.features.provision.folders.defaultContentFolder.workflowFolder.scmPath,
          autoImport = true)

        applyLatestContent(workflowsFolder.getId, workflowsFolder.getTitle)

        // Event listeners are not subscribed yet, we need to do snapshot manually
        permissionSnapshotService.makeSnapshot(Option(DEFAULT_CONTENT_FOLDER_ID))
        permissionSnapshotService.makeSnapshot(Option(workflowsFolder.getId))
        permissionSnapshotService.makeSnapshot(Option(workflowsExecutionFolder.getId))
      } match {
        case Failure(exception) => logger.error("Failure while creating and importing content for the default content folder", exception)
        case Success(_) => logger.debug(s"Finished creation of default content folder")
      }
    } else {
      logger.info(s"Skipped default content folder creation as folder provisioning is disabled")
    }
    true
  }

}
