package com.xebialabs.xlrelease.ascode.yaml.parser

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.ascode.yaml.parser.ValueTagPreprocessingConstructor.VALUE_TAG
import grizzled.slf4j.Logging
import org.yaml.snakeyaml.LoaderOptions
import org.yaml.snakeyaml.constructor.{AbstractConstruct, Constructor}
import org.yaml.snakeyaml.nodes.{Node, ScalarNode, Tag}

object ValueTagPreprocessingConstructor {
  val VALUE_TAG = "!value"
}

// Not sure if this should be in this package since it's only used during folder verioning yaml parsing
class ValueTagPreprocessingConstructor(loaderOptions: LoaderOptions) extends Constructor(loaderOptions) with Logging {
  private val tag = new Tag(VALUE_TAG)
  this.yamlConstructors.put(tag, new ValueTagConstruct)

   private class ValueTagConstruct extends AbstractConstruct {
    override def construct(node: Node): Object = {
      node match {
        case sn: ScalarNode =>
          // return the tag and placeholder as string
          s"$VALUE_TAG ${sn.getValue}"
        case _ => throw new AsCodeException(s"Only scalar nodes are supported for $VALUE_TAG tags.")
      }
    }
  }
}
