package com.xebialabs.xlrelease.ascode.rest.support

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlrelease.ascode.rest.support.SCMDataMessageBodyReader._
import org.joda.time.DateTime
import org.springframework.stereotype.Component

import java.io.InputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyReader, Provider}
import scala.jdk.CollectionConverters._

object SCMDataMessageBodyReader {

  implicit class EnhancedMultivaluedMap(map: MultivaluedMap[String, String]) {
    def optionalHeader(key: String): Option[String] = {
      Option(map.get(key).asScala)
        .toList
        .flatten
        .headOption
    }

    def requiredHeader(key: String): String = optionalHeader(key).getOrElse {
      throw new Exception(s"Missing required SCM header: $key")
    }
  }

}

@Component
@Provider
class SCMDataMessageBodyReader extends MessageBodyReader[SCMTraceabilityData] {
  override def isReadable(`type`: Class[_],
                          genericType: Type,
                          annotations: Array[Annotation],
                          mediaType: MediaType): Boolean = classOf[SCMTraceabilityData].isAssignableFrom(`type`)

  override def readFrom(`type`: Class[SCMTraceabilityData],
                        genericType: Type,
                        annotations: Array[Annotation],
                        mediaType: MediaType,
                        httpHeaders: MultivaluedMap[String, String],
                        entityStream: InputStream): SCMTraceabilityData = {
    httpHeaders.optionalHeader("X-Xebialabs-Scm-Type").map { kind =>
      new SCMTraceabilityData(
        kind,
        httpHeaders.requiredHeader("X-Xebialabs-Scm-Commit"),
        httpHeaders.requiredHeader("X-Xebialabs-Scm-Author"),
        DateTime.parse(httpHeaders.requiredHeader("X-Xebialabs-Scm-Date")),
        httpHeaders.optionalHeader("X-Xebialabs-Scm-Message").orNull,
        httpHeaders.optionalHeader("X-Xebialabs-Scm-Remote").orNull,
        httpHeaders.requiredHeader("X-Xebialabs-Scm-Filename")
      )
    }.getOrElse(new SCMTraceabilityData())
  }
}
