package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.variables.ReferenceVariable
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class ReferenceVariableStringReferenceCreationHandler(configurationRepository: ConfigurationRepository) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[ReferenceVariable]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val variable = config.ci.asInstanceOf[ReferenceVariable]
    val descriptor = variable.getType.getDescriptor.getPropertyDescriptor("value")
    val referencedConfiguration = Option(variable.getValue).map { referencedName =>
      configurationRepository.findAllByTypeAndTitle[BaseConfiguration](
          Type.valueOf(variable.getReferencedType), referencedName, config.folderPath, folderOnly = false).asScala
        .sortBy(ci => Option(ci.getFolderId).getOrElse(""))(Ordering.String.reverse)
        .headOption.getOrElse(
          throw new AsCodeException(s"Configuration '${variable.getValue}' of type '${variable.getReferencedType}' was not found in folder hierarchy. " +
            s"Please create it before referencing it in variable.")
        )
    }
    StringReferenceContainer(config.ci, Map(descriptor -> referencedConfiguration.map(_.getId)))
  }
}
