/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.scm.data.VersionsView;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.form.CreateVersionForm;
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReport;
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReportMessage;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.VersioningStyle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Path(value="api/v1/folders/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\r]b\u0001B\r\u001b\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqA!\u0011\u0001\t\u0003\u0011\u0019\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\t-\u0004\u0001\"\u0001\u0003n!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BL\u0001\u0011\u0005!\u0011\u0014\u0005\b\u0005O\u0003A\u0011\u0001BU\u0011\u001d\u00119\f\u0001C\u0001\u0005sCqA!6\u0001\t\u0003\u00119\u000eC\u0004\u0003n\u0002!\tAa<\t\u000f\tu\b\u0001\"\u0001\u0003\u0000\nAbi\u001c7eKJ4VM]:j_:Lgn\u001a*fg>,(oY3\u000b\u0005ma\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005uq\u0012aA1qS*\u0011q\u0004I\u0001\nq2\u0014X\r\\3bg\u0016T!!\t\u0012\u0002\u0013a,'-[1mC\n\u001c(\"A\u0012\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\tOJL'P\u001f7fI&\u00111G\f\u0002\b\u0019><w-\u001b8h\u0003E\u0001XM]7jgNLwN\\\"iK\u000e\\WM\u001d\t\u0003mej\u0011a\u000e\u0006\u0003qy\t\u0001b]3dkJLG/_\u0005\u0003u]\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0003]1w\u000e\u001c3feZ+'o]5p]&twmU3sm&\u001cW\r\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006\u00191oY7\u000b\u0005\u0005\u0013\u0015AB1tG>$WM\u0003\u0002D=\u0005Qa/\u001a:tS>t\u0017N\\4\n\u0005\u0015s$a\u0006$pY\u0012,'OV3sg&|g.\u001b8h'\u0016\u0014h/[2f\u00039\u0001(/\u001a<jK^\u001cVM\u001d<jG\u0016\u0004\"!\u0010%\n\u0005%s$A\b$pY\u0012,'OV3sg&|g.\u001b8h!J,g/[3x'\u0016\u0014h/[2f\u0003q1w\u000e\u001c3feZ+'o]5p]&tw-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001T(\u000e\u00035S!A\u0014!\u0002\r\u0005\u001cGo\u001c:t\u0013\t\u0001VJ\u0001\u000fG_2$WM\u001d,feNLwN\\5oO\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0015\u0019VKV,Y!\t!\u0006!D\u0001\u001b\u0011\u0015!T\u00011\u00016\u0011\u0015YT\u00011\u0001=\u0011\u00151U\u00011\u0001H\u0011\u0015QU\u00011\u0001LQ\t)!\f\u0005\u0002\\M6\tAL\u0003\u0002^=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005}\u0003\u0017a\u00024bGR|'/\u001f\u0006\u0003C\n\fQAY3b]NT!a\u00193\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Z\u0001\u0004_J<\u0017BA4]\u0005%\tU\u000f^8xSJ,G-A\u0006hKR\u001cV\r\u001e;j]\u001e\u001cHC\u00016s!\tY\u0007/D\u0001m\u0015\t\tUN\u0003\u0002D]*\u0011qNH\u0001\u0007I>l\u0017-\u001b8\n\u0005Ed'\u0001\u0007$pY\u0012,'OV3sg&|g.\u001b8h'\u0016$H/\u001b8hg\")1O\u0002a\u0001i\u0006Aam\u001c7eKJLE\r\u0005\u0002vy:\u0011aO\u001f\t\u0003o\"j\u0011\u0001\u001f\u0006\u0003s\u0012\na\u0001\u0010:p_Rt\u0014BA>)\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mD\u0003f\u0002:\u0002\u0002\u0005U\u0011q\u0003\t\u0005\u0003\u0007\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\t\u00118O\u0003\u0003\u0002\f\u00055\u0011AA<t\u0015\t\ty!A\u0004kC.\f'\u000f^1\n\t\u0005M\u0011Q\u0001\u0002\n!\u0006$\b\u000eU1sC6\fQA^1mk\u0016\f\u0013a\u001d\u0015\u0004\r\u0005m\u0001\u0003BA\u0002\u0003;IA!a\b\u0002\u0006\t\u0019q)\u0012+)\u000f\u0019\t\u0019#!\u0006\u0002*A!\u00111AA\u0013\u0013\u0011\t9#!\u0002\u0003\tA\u000bG\u000f[\u0011\u0003\u0003W\t1dL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|\u0013AD;qI\u0006$XmU3ui&twm\u001d\u000b\u0006U\u0006E\u0012Q\u0007\u0005\u0006g\u001e\u0001\r\u0001\u001e\u0015\t\u0003c\t\t!!\u0006\u0002\u0018!1\u0011qG\u0004A\u0002)\faaY8oM&<\u0007fA\u0004\u0002<A!\u00111AA\u001f\u0013\u0011\ty$!\u0002\u0003\u0007A+F\u000bK\u0004\b\u0003G\t)\"!\u000b\u0002\u001d\u0011,G.\u001a;f'\u0016$H/\u001b8hgR!\u0011qIA'!\r9\u0013\u0011J\u0005\u0004\u0003\u0017B#\u0001B+oSRDQa\u001d\u0005A\u0002QD\u0003\"!\u0014\u0002\u0002\u0005U\u0011q\u0003\u0015\u0004\u0011\u0005M\u0003\u0003BA\u0002\u0003+JA!a\u0016\u0002\u0006\t1A)\u0012'F)\u0016Cs\u0001CA\u0012\u0003+\tI#A\u0006hKR4VM]:j_:\u001cHCBA0\u0003[\n\t\b\u0005\u0003\u0002b\u0005%TBAA2\u0015\u0011\t)'a\u001a\u0002\t\u0011\fG/\u0019\u0006\u0003\u007fyIA!a\u001b\u0002d\taa+\u001a:tS>t7OV5fo\")1/\u0003a\u0001i\"B\u0011QNA\u0001\u0003+\t9\u0002C\u0004\u0002t%\u0001\r!!\u001e\u0002\u0019\u0019,Go\u00195DQ\u0006tw-Z:\u0011\u0007\u001d\n9(C\u0002\u0002z!\u0012qAQ8pY\u0016\fg\u000e\u000b\u0005\u0002r\u0005u\u0014QCAB!\u0011\t\u0019!a \n\t\u0005\u0005\u0015Q\u0001\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0003\u0003\u000b\u000bQAZ1mg\u0016D\u0003\"!\u001d\u0002\n\u0006U\u0011q\u0012\t\u0005\u0003\u0007\tY)\u0003\u0003\u0002\u000e\u0006\u0015!AC)vKJL\b+\u0019:b[\u0006\u0012\u00111\u000f\u0015\u0004\u0013\u0005m\u0001fB\u0005\u0002$\u0005U\u0011QS\u0011\u0003\u0003/\u000b1eL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|c/\u001a:tS>t7/A\u0007de\u0016\fG/\u001a,feNLwN\u001c\u000b\u0007\u0003;\u000b\u0019+a*\u0011\t\u0005\u0005\u0014qT\u0005\u0005\u0003C\u000b\u0019GA\u0006WKJ\u001c\u0018n\u001c8J]\u001a|\u0007\"B:\u000b\u0001\u0004!\b\u0006CAR\u0003\u0003\t)\"a\u0006\t\u000f\u0005%&\u00021\u0001\u0002,\u0006Ya/\u001a:tS>tgi\u001c:n!\u0011\ti+a-\u000e\u0005\u0005=&bAAY\u0001\u0006!am\u001c:n\u0013\u0011\t),a,\u0003#\r\u0013X-\u0019;f-\u0016\u00148/[8o\r>\u0014X\u000eK\u0002\u000b\u0003s\u0003B!a\u0001\u0002<&!\u0011QXA\u0003\u0005\u0011\u0001vj\u0015+)\u000f)\t\u0019#!\u0006\u0002\u0016\u0006a\u0011\r\u001d9msZ+'o]5p]R1\u0011qIAc\u0003\u0013DQa]\u0006A\u0002QD\u0003\"!2\u0002\u0002\u0005U\u0011q\u0003\u0005\u0007\u0003\u0017\\\u0001\u0019\u0001;\u0002\u000fY,'o]5p]\"B\u0011\u0011ZA\u0001\u0003+\ty-\t\u0002\u0002L\"\u001a1\"!/)\u000f-\t\u0019#!\u0006\u0002V\u0006\u0012\u0011q[\u00017_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018wKJ\u001c\u0018n\u001c8t_m4XM]:j_:TdFK?0CB\u0004H._\u0001\u000faJ,g/[3x\u0007V\u0014(/\u001a8u)\u0015!\u0018Q\\Aq\u0011\u0015\u0019H\u00021\u0001uQ!\ti.!\u0001\u0002\u0016\u0005]\u0001BBAr\u0019\u0001\u0007A/\u0001\u0005gS2,g.Y7fQ!\t\t/!#\u0002\u0016\u0005\u001d\u0018EAArQ\ra\u00111\u0004\u0015\b\u0019\u00055\u0018QCAz!\u0011\t\u0019!a<\n\t\u0005E\u0018Q\u0001\u0002\t!J|G-^2fg2\u0012\u0011Q_\u0011\u0003\u0003o\fQ\u0002^3yi>2h\u000e\u001a\u0018zC6d\u0007f\u0002\u0007\u0002$\u0005U\u00111`\u0011\u0003\u0003{\f!eL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|\u0003O]3wS\u0016<\u0018A\u00049sKZLWm\u001e,feNLwN\u001c\u000b\bi\n\r!q\u0001B\u0006\u0011\u0015\u0019X\u00021\u0001uQ!\u0011\u0019!!\u0001\u0002\u0016\u0005]\u0001BBAf\u001b\u0001\u0007A\u000f\u000b\u0005\u0003\b\u0005\u0005\u0011QCAh\u0011\u0019\t\u0019/\u0004a\u0001i\"B!1BAE\u0003+\t9\u000fK\u0002\u000e\u00037As!DAw\u0003+\u0011\u0019\u0002\f\u0002\u0002v\":Q\"a\t\u0002\u0016\t]\u0011E\u0001B\r\u0003az3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_Y,'o]5p]N|3P^3sg&|gN\u000f\u0018+{>\u0002(/\u001a<jK^\fQcZ3u-\u0016\u00148/[8oK\u00124\u0015\u000e\\3OC6,7\u000f\u0006\u0004\u0003 \tE\"Q\u0007\t\u0006\u0005C\u0011Y\u0003\u001e\b\u0005\u0005G\u00119CD\u0002x\u0005KI\u0011!K\u0005\u0004\u0005SA\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005[\u0011yC\u0001\u0003MSN$(b\u0001B\u0015Q!)1O\u0004a\u0001i\"B!\u0011GA\u0001\u0003+\t9\u0002\u0003\u0004\u0002L:\u0001\r\u0001\u001e\u0015\t\u0005k\t\t!!\u0006\u0002P\"\u001aa\"a\u0007)\u000f9\t\u0019#!\u0006\u0003>\u0005\u0012!qH\u0001G_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018wKJ\u001c\u0018n\u001c8t_m4XM]:j_:TdFK?0O\u0016$h+\u001a:tS>tW\r\u001a$jY\u0016t\u0015-\\3t\u0003y9W\r^\"veJ,g\u000e\u001e,feNLwN\\1cY\u00164\u0015\u000e\\3OC6,7\u000f\u0006\u0003\u0003 \t\u0015\u0003\"B:\u0010\u0001\u0004!\b\u0006\u0003B#\u0003\u0003\t)\"a\u0006)\u0007=\tY\u0002K\u0004\u0010\u0003G\t)B!\u0014\"\u0005\t=\u0013AM\u0018|M>dG-\u001a:JIjr#FR8mI\u0016\u00148LX\u0018.;*jxfZ3u-\u0016\u00148/[8oC\ndWMR5mK:\u000bW.Z:\u0002\u001f\u0011,G.\u001a;f\u0019>\u001c\u0017\r\u001c*fa>$b!a\u0012\u0003V\te\u0003\"B:\u0011\u0001\u0004!\b\u0006\u0003B+\u0003\u0003\t)\"a\u0006\t\u000f\tm\u0003\u00031\u0001\u0002v\u0005Y1\r\\;ti\u0016\u0014x+\u001b3fQ!\u0011I&! \u0002\u0016\u0005\r\u0005\u0006\u0003B-\u0003\u0013\u000b)B!\u0019\"\u0005\tm\u0003f\u0001\t\u0002T!:\u0001#a\t\u0002\u0016\t\u001d\u0014E\u0001B5\u00031z3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_\u0011,G.\u001a;f[1|7-\u00197.e\u0016\u0004x.\u0001\bsKN,G\u000fT8dC2\u0014V\r]8\u0015\r\u0005\u001d#q\u000eB:\u0011\u0015\u0019\u0018\u00031\u0001uQ!\u0011y'!\u0001\u0002\u0016\u0005]\u0001b\u0002B.#\u0001\u0007\u0011Q\u000f\u0015\t\u0005g\ni(!\u0006\u0002\u0004\"B!1OAE\u0003+\u0011\t\u0007K\u0002\u0012\u0003wAs!EA\u0012\u0003+\u0011i(\t\u0002\u0003\u0000\u0005Ysf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>\u0012Xm]3u[1|7-\u00197.e\u0016\u0004x.A\bwC2LG-\u0019;f\u0007V\u0014(/\u001a8u)\u0011\u0011)Ia#\u0011\t\u00055&qQ\u0005\u0005\u0005\u0013\u000byK\u0001\tWC2LG-\u0019;j_:\u0014V\r]8si\")1O\u0005a\u0001i\"B!1RA\u0001\u0003+\t9\u0002K\u0002\u0013\u00037AsAEA\u0012\u0003+\u0011\u0019*\t\u0002\u0003\u0016\u0006\u0019sf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>2\u0018\r\\5eCR,\u0017!F4fiZ\u000bG.\u001b3bi&|g.T3tg\u0006<Wm\u001d\u000b\u0005\u0005\u000b\u0013Y\nC\u0003t'\u0001\u0007A\u000f\u000b\u0005\u0003\u001c\u0006\u0005\u0011QCA\fQ\r\u0019\u00121\u0004\u0015\b'\u0005\r\u0012Q\u0003BRC\t\u0011)+\u0001\u00180w\u001a|G\u000eZ3s\u0013\u0012TdF\u000b$pY\u0012,'o\u001700[uSSp\f<bY&$\u0017\r^5p]6jWm]:bO\u0016\u001c\u0018!F:fiZ\u000bG.\u001b3bi&|g.T3tg\u0006<Wm\u001d\u000b\u0007\u0003\u000f\u0012YKa,\t\u000bM$\u0002\u0019\u0001;)\u0011\t-\u0016\u0011AA\u000b\u0003/AqA!-\u0015\u0001\u0004\u0011))\u0001\twC2LG-\u0019;j_:\u0014V\r]8si\"\u001aA#a\u000f)\u000fQ\t\u0019#!\u0006\u0003$\u0006!r-\u001a;WC2LG-\u0019;j_:lUm]:bO\u0016$bAa/\u0003B\n\u0015\u0007\u0003BAW\u0005{KAAa0\u00020\n9b+\u00197jI\u0006$\u0018n\u001c8SKB|'\u000f^'fgN\fw-\u001a\u0005\u0006gV\u0001\r\u0001\u001e\u0015\t\u0005\u0003\f\t!!\u0006\u0002\u0018!1!qY\u000bA\u0002Q\f\u0011\"\\3tg\u0006<W-\u00133)\u0011\t\u0015\u0017\u0011AA\u000b\u0005\u0017\f#Aa2)\u0007U\tY\u0002K\u0004\u0016\u0003G\t)B!5\"\u0005\tM\u0017AM\u0018|M>dG-\u001a:JIjr#FR8mI\u0016\u00148LX\u0018.;*jx&\\3tg\u0006<WmL>nKN\u001c\u0018mZ3JIjr#&`\u0018\u00027M,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fgN#\u0018\r^;t)!\t9E!7\u0003^\n\u0005\b\"B:\u0017\u0001\u0004!\b\u0006\u0003Bm\u0003\u0003\t)\"a\u0006\t\r\t\u001dg\u00031\u0001uQ!\u0011i.!\u0001\u0002\u0016\t-\u0007b\u0002Br-\u0001\u0007!1X\u0001\u0012m\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,\u0007f\u0001\f\u0002<!:a#a\t\u0002\u0016\t%\u0018E\u0001Bv\u0003az3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_5,7o]1hK>ZX.Z:tC\u001e,\u0017\n\u001a\u001e/Uu|S\u000f\u001d3bi\u0016\fAb\u00197fCJ\u001cVm\u0019:fiN$B!a\u0012\u0003r\")1o\u0006a\u0001i\"B!\u0011_A\u0001\u0003+\t9\u0002K\u0002\u0018\u0003'BsaFA\u0012\u0003+\u0011I0\t\u0002\u0003|\u0006Asf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>\u001aG.Z1s[M,7M]3ug\u0006\u0019r-\u001a;WKJ\u001c\u0018n\u001c8j]\u001e\u001cF/\u001f7fgV\u00111\u0011\u0001\t\u0007\u0005C\u0011Yca\u0001\u0011\u0007u\u001a)!C\u0002\u0004\by\u0012qBV3sg&|g.\u001b8h'RLH.\u001a\u0015\u00041\u0005m\u0001f\u0002\r\u0002$\u0005U1QB\u0011\u0003\u0007\u001f\tqaL:us2,7\u000fK\u0004\u0001\u0003G\t)ba\u0005\"\u0005\rU\u0011!G1qS>2\u0018g\f4pY\u0012,'o]\u0018wKJ\u001c\u0018n\u001c8j]\u001eDs\u0001AAw\u0003+\u0019I\u0002\f\u0002\u0004\u001c\u0005\u00121QD\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:Ds\u0001AB\u0011\u0003+\u00199\u0003\u0005\u0003\u0002\u0004\r\r\u0012\u0002BB\u0013\u0003\u000b\u0011\u0001bQ8ogVlWm\u001d\u0017\u0003\u00077A3\u0001AB\u0016!\u0011\u0019ica\r\u000e\u0005\r=\"bAB\u0019E\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\rU2q\u0006\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class FolderVersioningResource
implements Logging {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningResource folderVersioningResource = this;
        synchronized (folderVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)((Object)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        config.setFolderId(folderId);
        return this.folderVersioningActorService.createOrUpdateSettings(config);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionsView getVersions(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="fetchChanges") boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = fetchChanges ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionInfo createVersion(@PathParam(value="folderId") String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.name(), versionForm.description());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/apply")
    public void applyVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        this.folderVersioningService.applyVersion(folderId, version);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/preview")
    public String previewCurrent(@PathParam(value="folderId") String folderId, @QueryParam(value="filename") String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, filename);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/preview")
    public String previewVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version, @QueryParam(value="filename") String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/getVersionedFileNames")
    public List<String> getVersionedFileNames(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getVersionedFileNames(folderId, version);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/getVersionableFileNames")
    public List<String> getCurrentVersionableFileNames(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getVersionableFileNames(folderId);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/delete-local-repo")
    public void deleteLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, clusterWide);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/reset-local-repo")
    public void resetLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, clusterWide);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validate")
    public ValidationReport validateCurrent(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public ValidationReport getValidationMessages(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public void setValidationMessages(@PathParam(value="folderId") String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.warnings()).asScala().toSeq());
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/")
    public ValidationReportMessage getValidationMessage(@PathParam(value="folderId") String folderId, @PathParam(value="messageId") String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/update")
    public void setValidationMessagesStatus(@PathParam(value="folderId") String folderId, @PathParam(value="messageId") String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/clear-secrets")
    public void clearSecrets(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    @GET
    @Path(value="/styles")
    public List<VersioningStyle> getVersioningStyles() {
        return this.folderVersioningService.getVersioningStyles();
    }

    @Autowired
    public FolderVersioningResource(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        Logging.$init$((Logging)this);
    }
}

