package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.v1.{ApplicationApi, EnvironmentApi}
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.DeploymentTaskFacetStringCreationHandler._
import com.xebialabs.xlrelease.udm.reporting.DeploymentTaskFacet
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.{Failure, Success, Try}

@Autowired
@Component
class DeploymentTaskFacetGeneratorHandler(environmentApi: EnvironmentApi,
                                          applicationApi: ApplicationApi) extends CiReferenceGeneratorHandler {
  private val loadCi = Map[String, String => ConfigurationItem](
    `environmentIdField` -> environmentApi.getById,
    `applicationIdField` -> applicationApi.getById
  )

  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[DeploymentTaskFacet]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    properties.foreach { name =>
      val value = Option(ci.getProperty[String](name)).map(configId => {
        Try(loadCi(name)(configId)) match {
          case Success(configItem) => configItem.getProperty[String]("title")
          case Failure(exception) => null
        }
      }).orNull[String]
      ci.setProperty[String](name, value)
    }

  }
}
