package com.xebialabs.xlrelease.ascode.yaml.model.permission

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.yaml.model.permission.PermissionRelation
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._

import scala.jdk.CollectionConverters._

object TaskAccessRelation {
  def parseTaskAccess(node: JsonNode): TaskAccess = {
    val taskType = node.requiredString("type")
    val allowedToAll = node.requiredBoolean("allowedToAll")
    val roles = node.listOfStrings("roles")

    TaskAccess(taskType, allowedToAll, roles)
  }

  def parse(node: JsonNode): TaskAccessRelation = {
    TaskAccessRelation(node.elements().asScala.map(parseTaskAccess).toList)
  }
}

case class TaskAccess(`type`: String, allowedToAll: Boolean, @JsonInclude(Include.NON_EMPTY) roles: List[String])

case class TaskAccessRelation(@JsonInclude(Include.NON_EMPTY) taskAccess: List[TaskAccess]) extends PermissionRelation
