package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationService
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_RESERVATION
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Date
import scala.jdk.CollectionConverters._

@Component
class EnvironmentReservationAsCodeGenerator @Autowired()(environmentReservationService: EnvironmentReservationService,
                                                         permissions: PermissionChecker)
  extends ApplicationEnvironmentGenerateStrategy[EnvironmentReservation] {

  override val generateOrder: Double = 400

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateEnvironments
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[EnvironmentReservation]] = {
    if (config.isAdminUser || permissions.hasGlobalPermission(EDIT_RESERVATION)) {
      val reservations =
        environmentReservationService.searchReservations(new ReservationFilters(null, null, null, null, new Date(), null)).asScala
        .flatMap { case (_, reservations) =>
          reservations.asScala.toList
            .filter { envRes =>
              config.ciTitle.forall { n => Utils.stringLike(envRes.getEnvironment.getTitle, n) }
            }
        }.toList
      Map(None -> reservations)
    } else {
      Map.empty
    }
  }

}
