/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.xlrelease.ascode.service.FileResolver;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\b\u0011\u0001mA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006o\u0001!\t\u0001\u000f\u0005\bw\u0001\u0001\r\u0011\"\u0003=\u0011\u001d\t\u0006\u00011A\u0005\nICa\u0001\u0017\u0001!B\u0013i\u0004\u0002C-\u0001\u0011\u000b\u0007I\u0011\u0002.\t\u0011y\u0003\u0001R1A\u0005\n}CQ\u0001\u001b\u0001\u0005B%DQa\u001c\u0001\u0005BADQ!\u001d\u0001\u0005\nIDQa\u001d\u0001\u0005\nQDQ\u0001\u001f\u0001\u0005\neDQa\u001f\u0001\u0005\nqDaa \u0001\u0005\n\u0005\u0005!\u0001\u0005+f[B4\u0015\u000e\\3SKN|GN^3s\u0015\t\t\"#A\u0004tKJ4\u0018nY3\u000b\u0005M!\u0012AB1tG>$WM\u0003\u0002\u0016-\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u000f#UA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n\u0001b\u001a:jujdW\rZ\u0005\u0003S\u0011\u0012q\u0001T8hO&tw\r\u0005\u0002,Y5\t\u0001#\u0003\u0002.!\taa)\u001b7f%\u0016\u001cx\u000e\u001c<fe\u0006\u0011\u0011N\u001c\t\u0003aUj\u0011!\r\u0006\u0003eM\n!![8\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u0004=S:LGO\u0010\u000b\u0003si\u0002\"a\u000b\u0001\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u0013Q,W\u000e\u001d$jY\u0016\u001cX#A\u001f\u0011\ty*\u0005j\u0013\b\u0003\u007f\r\u0003\"\u0001\u0011\u0010\u000e\u0003\u0005S!A\u0011\u000e\u0002\rq\u0012xn\u001c;?\u0013\t!e$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u00131!T1q\u0015\t!e\u0004\u0005\u0002?\u0013&\u0011!j\u0012\u0002\u0007'R\u0014\u0018N\\4\u0011\u00051{U\"A'\u000b\u000593\u0012!C8wKJ$\b.\u001a:f\u0013\t\u0001VJA\u0007Pm\u0016\u0014H\u000f[3sK\u001aKG.Z\u0001\u000ei\u0016l\u0007OR5mKN|F%Z9\u0015\u0005M3\u0006CA\u000fU\u0013\t)fD\u0001\u0003V]&$\bbB,\u0005\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\n\u0014A\u0003;f[B4\u0015\u000e\\3tA\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u0016\u0003m\u0003\"\u0001\u0014/\n\u0005uk%aE(wKJ$\b.\u001a:f\u0007>tg.Z2uS>t\u0017a\u0002>ja\u001aKG.Z\u000b\u0002AB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0004u&\u0004(BA34\u0003\u0011)H/\u001b7\n\u0005\u001d\u0014'a\u0002.ja\u001aKG.Z\u0001\be\u0016\u001cx\u000e\u001c<f)\tQW\u000eE\u0002\u001eW.K!\u0001\u001c\u0010\u0003\r=\u0003H/[8o\u0011\u0015q\u0007\u00021\u0001I\u0003\r\u0011XMZ\u0001\u0006G2|7/\u001a\u000b\u0002'\u0006!q\u000e]3o)\u0005\u0001\u0017AD2sK\u0006$X\rV3na\u001aKG.\u001a\u000b\u0004\u0017V<\b\"\u0002<\f\u0001\u0004A\u0015\u0001\u00034jY\u0016t\u0017-\\3\t\u000b9Z\u0001\u0019A\u0018\u0002'\u0011,'-^4MSN$(,\u001b9F]R\u0014\u0018.Z:\u0015\u0005MS\b\"B2\r\u0001\u0004\u0001\u0017!F4fi2{7-\u00197Pm\u0016\u0014H\u000f[3sK\u001aKG.\u001a\u000b\u0003UvDQA`\u0007A\u0002!\u000bA\u0001]1uQ\u000691\r\\3b]V\u0004H#B*\u0002\u0004\u0005\u0015\u0001\"B-\u000f\u0001\u0004Y\u0006\"\u00020\u000f\u0001\u0004\u0001\u0007")
public class TempFileResolver
implements Logging,
FileResolver {
    private OverthereConnection connection;
    private ZipFile zipFile;
    private final InputStream in;
    private Map<String, OverthereFile> tempFiles;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TempFileResolver tempFileResolver = this;
        synchronized (tempFileResolver) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Map<String, OverthereFile> tempFiles() {
        return this.tempFiles;
    }

    private void tempFiles_$eq(Map<String, OverthereFile> x$1) {
        this.tempFiles = x$1;
    }

    private OverthereConnection connection$lzycompute() {
        TempFileResolver tempFileResolver = this;
        synchronized (tempFileResolver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.connection = LocalConnection.getLocalConnection();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.connection;
    }

    private OverthereConnection connection() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.connection$lzycompute();
        }
        return this.connection;
    }

    private ZipFile zipFile$lzycompute() {
        TempFileResolver tempFileResolver = this;
        synchronized (tempFileResolver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.zipFile = this.open();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.zipFile;
    }

    private ZipFile zipFile() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.zipFile$lzycompute();
        }
        return this.zipFile;
    }

    @Override
    public Option<OverthereFile> resolve(String ref) {
        return this.getLocalOverthereFile(ref);
    }

    @Override
    public void close() {
        this.cleanup(this.connection(), this.zipFile());
    }

    private ZipFile open() {
        this.logger().debug((Function0 & Serializable)() -> "Opening TempFileMapper");
        OverthereFile archiveFile = this.createTempFile("archive.zip", this.in);
        ZipFile zipFile = new ZipFile(Paths.get(archiveFile.getPath(), new String[0]).toFile());
        this.debugListZipEntries(zipFile);
        return zipFile;
    }

    private OverthereFile createTempFile(String filename, InputStream in) {
        OverthereFile outputFile = this.connection().getTempFile(filename);
        Path outputPath = Paths.get(outputFile.getPath(), new String[0]);
        this.logger().debug((Function0 & Serializable)() -> "Writing temporary file for `" + filename + "` at `" + outputFile.toString() + "`");
        Files.copy(in, outputPath, new CopyOption[0]);
        return outputFile;
    }

    private void debugListZipEntries(ZipFile zip) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "Listing ZipEntries");
            CollectionConverters$.MODULE$.EnumerationHasAsScala(zip.entries()).asScala().foreach((Function1 & Serializable)entry -> {
                TempFileResolver.$anonfun$debugListZipEntries$2(this, entry);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Option<OverthereFile> getLocalOverthereFile(String path) {
        if (this.tempFiles().contains((Object)path)) {
            this.logger().debug((Function0 & Serializable)() -> "Reusing file for `" + path + "`");
            return this.tempFiles().get((Object)path);
        }
        return Option$.MODULE$.apply((Object)this.zipFile().getEntry(path)).map((Function1 & Serializable)entry -> {
            if (entry.isDirectory()) {
                throw new AsCodeException("Not allowed to reference a directory: `" + path + "`. Directories should be zipped.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            InputStream in = this.zipFile().getInputStream((ZipEntry)entry);
            String fileName = ((Object)Paths.get(path, new String[0]).getFileName()).toString();
            OverthereFile outputFile = this.createTempFile(fileName, in);
            this.tempFiles_$eq((Map<String, OverthereFile>)((Map)this.tempFiles().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)outputFile))));
            return outputFile;
        });
    }

    private void cleanup(OverthereConnection connection, ZipFile zipFile) {
        this.logger().debug((Function0 & Serializable)() -> "Cleaning up");
        zipFile.close();
        connection.close();
    }

    public static final /* synthetic */ void $anonfun$debugListZipEntries$2(TempFileResolver $this, ZipEntry entry) {
        $this.logger().debug((Function0 & Serializable)() -> "ZipEntry [name: `" + entry.getName() + "`, directory: " + entry.isDirectory() + ", size: " + entry.getSize() + " bytes], crc: [" + entry.getCrc() + "]");
    }

    public TempFileResolver(InputStream in) {
        this.in = in;
        Logging.$init$((Logging)this);
        this.tempFiles = Predef$.MODULE$.Map().empty();
    }
}

