/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningConfigService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService$;
import com.xebialabs.xlrelease.versioning.ascode.scm.ImportCrawler;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnectorInitializer;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\b\u0010\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u001d1\u0007!%A\u0005\u0002\u001dDQ!\u001d\u0001\u0005\nIDq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0002\u001f\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u0004&/\u001a<jK^\u001cVM\u001d<jG\u0016T!\u0001E\t\u0002\u0007M\u001cWN\u0003\u0002\u0013'\u00051\u0011m]2pI\u0016T!\u0001F\u000b\u0002\u0015Y,'o]5p]&twM\u0003\u0002\u0017/\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003Q\u0019wN\u001c8fGR|'/\u00138ji&\fG.\u001b>feB\u0011Q\u0005K\u0007\u0002M)\u0011qeD\u0001\nG>tg.Z2u_JL!!\u000b\u0014\u0003=\u0005\u001b8i\u001c3f\u0015\u001eKGoQ8o]\u0016\u001cGo\u001c:J]&$\u0018.\u00197ju\u0016\u0014\u0018!\b4pY\u0012,'OV3sg&|g.\u001b8h\u0007>tg-[4TKJ4\u0018nY3\u0011\u00051jS\"A\b\n\u00059z!!\b$pY\u0012,'OV3sg&|g.\u001b8h\u0007>tg-[4TKJ4\u0018nY3\u0002/Y,'o]5p]&twm\u0015;zY\u0016\u0014Vm]8mm\u0016\u0014\bCA\u00195\u001b\u0005\u0011$BA\u001a\u0010\u0003!\u0019HO]1uK\u001eL\u0018BA\u001b3\u0005i1VM]:j_:LgnZ*ue\u0006$XmZ=SKN|GN^3s\u00039IW\u000e]8siN\u001c%/Y<mKJ\u0004\"\u0001\f\u001d\n\u0005ez!!D%na>\u0014Ho\u0011:bo2,'/\u0001\u0004=S:LGO\u0010\u000b\u0006yurt\b\u0011\t\u0003Y\u0001AQaI\u0003A\u0002\u0011BQAK\u0003A\u0002-BQaL\u0003A\u0002ABQAN\u0003A\u0002]B#!\u0002\"\u0011\u0005\rsU\"\u0001#\u000b\u0005\u00153\u0015AC1o]>$\u0018\r^5p]*\u0011q\tS\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI%*A\u0003cK\u0006t7O\u0003\u0002L\u0019\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0012\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u001f\u001d,g.\u001a:bi\u0016\u0004&/\u001a<jK^$BAU/`IB\u00111K\u0017\b\u0003)b\u0003\"!V\u0010\u000e\u0003YS!aV\u000e\u0002\rq\u0012xn\u001c;?\u0013\tIv$\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA- \u0011\u0015qf\u00011\u0001S\u0003!1w\u000e\u001c3fe&#\u0007\"\u00021\u0007\u0001\u0004\t\u0017a\u0002<feNLwN\u001c\t\u0004=\t\u0014\u0016BA2 \u0005\u0019y\u0005\u000f^5p]\"9QM\u0002I\u0001\u0002\u0004\u0011\u0016\u0001\u00034jY\u0016t\u0015-\\3\u00023\u001d,g.\u001a:bi\u0016\u0004&/\u001a<jK^$C-\u001a4bk2$HeM\u000b\u0002Q*\u0012!+[\u0016\u0002UB\u00111n\\\u0007\u0002Y*\u0011QN\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!!R\u0010\n\u0005Ad'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061r-\u001a8fe\u0006$XMV3sg&|g\u000e\u0015:fm&,w\u000fF\u0004tsj\fI!a\u0005\u0011\u0005Q<X\"A;\u000b\u0005\u001d2(B\u0001\t\u0016\u0013\tAXO\u0001\u0006CS:\f'/\u001f$jY\u0016DQ!\u001a\u0005A\u0002ICQa\u001f\u0005A\u0002q\faaY8oM&<\u0007cA?\u0002\u00065\taP\u0003\u0002\u0013\u007f*\u0019A#!\u0001\u000b\u0007\u0005\rQ#\u0001\u0004e_6\f\u0017N\\\u0005\u0004\u0003\u000fq(\u0001\u0007$pY\u0012,'OV3sg&|g.\u001b8h'\u0016$H/\u001b8hg\"9\u00111\u0002\u0005A\u0002\u00055\u0011a\u00044jY\u0016\u001cHk\\\"iK\u000e\\w.\u001e;\u0011\ty\tyAU\u0005\u0004\u0003#y\"!B!se\u0006L\bBBA\u000b\u0011\u0001\u0007!+A\u0002wKJ\f!dZ3oKJ\fG/Z+om\u0016\u00148/[8oK\u0012\u0004&/\u001a<jK^$ra]A\u000e\u0003;\ty\u0002C\u0003_\u0013\u0001\u0007!\u000bC\u0003f\u0013\u0001\u0007!\u000b\u0003\u0004\u0002\"%\u0001\r\u0001`\u0001\tg\u0016$H/\u001b8hg\u0006\u0019r-\u001a;GS2,7OR8s\u0007\",7m[8viR1\u0011QBA\u0014\u0003SAQ!\u001a\u0006A\u0002ICQa\u001f\u0006A\u0002q\f1C^3sS\u001aL(+Z9vKN$X\r\u001a$jY\u0016$\"\"a\f\u00026\u0005]\u0012\u0011HA!!\rq\u0012\u0011G\u0005\u0004\u0003gy\"\u0001B+oSRDQ!Z\u0006A\u0002ICQa_\u0006A\u0002qDa\u0001E\u0006A\u0002\u0005m\u0002cA\u0013\u0002>%\u0019\u0011q\b\u0014\u0003'\u0005\u001b8i\u001c3f\u0015\u001eKGoQ8o]\u0016\u001cGo\u001c:\t\u000b\u0001\\\u0001\u0019\u0001*\u0002!\u001d,GOU3rk\u0016\u001cH/\u001a3GS2,G#B:\u0002H\u0005E\u0003bBA%\u0019\u0001\u0007\u00111J\u0001\u000bG\",7m[3e\u001fV$\bc\u0001;\u0002N%\u0019\u0011qJ;\u0003\u0011M\u001bWN\u00117pENDQ!\u001a\u0007A\u0002I\u000b1bZ3u'\u0016$H/\u001b8hgR\u0019A0a\u0016\t\u000byk\u0001\u0019\u0001*)\u0007\u0001\tY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGS\u0001\u000bgR,'/Z8usB,\u0017\u0002BA3\u0003?\u0012\u0011bQ8na>tWM\u001c;")
public class FolderVersioningPreviewService {
    private final AsCodeJGitConnectorInitializer connectorInitializer;
    private final FolderVersioningConfigService folderVersioningConfigService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final ImportCrawler importsCrawler;

    public String generatePreview(String folderId, Option<String> version, String fileName) {
        return (String)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> {
            BinaryFile binaryFile;
            FolderVersioningSettings config = this.getSettings(folderId);
            String finalFileName = fileName.isEmpty() ? FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME() : fileName;
            String[] filesToCheckout = this.getFilesForCheckout(finalFileName, config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                binaryFile = this.generateVersionPreview(finalFileName, config, filesToCheckout, ver);
            } else if (None$.MODULE$.equals(option)) {
                binaryFile = this.generateUnversionedPreview(folderId, finalFileName, config);
            } else {
                throw new MatchError((Object)option);
            }
            BinaryFile blobs = binaryFile;
            return new String((byte[])blobs.getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public String generatePreview$default$3() {
        return FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME();
    }

    private BinaryFile generateVersionPreview(String fileName, FolderVersioningSettings config, String[] filesToCheckout, String ver) {
        String filenameWithPath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config.scmPath(), fileName);
        return (BinaryFile)Using$.MODULE$.resource((Object)this.connectorInitializer.init(config), (Function1 & Serializable)scmConnector -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> scmConnector.checkout(filesToCheckout, ver, false));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ScmBlobs checkedOut = (ScmBlobs)success.value();
                if (!fileName.equals(FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())) {
                    this.verifyRequestedFile(fileName, config, (AsCodeJGitConnector)scmConnector, ver);
                }
                return this.getRequestedFile(checkedOut, filenameWithPath);
            }
            if (try_ instanceof Failure) {
                ScmException scmException;
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (ex instanceof ScmException && (scmException = (ScmException)ex).getMessage().contains("No definition file found for tag")) {
                    throw new NotFoundException(scmException.getMessage(), new Object[0]);
                }
            }
            if (bl) {
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError((Object)try_);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private BinaryFile generateUnversionedPreview(String folderId, String fileName, FolderVersioningSettings settings) {
        Seq allFiles = this.versioningStyleResolver.resolve(settings.versioningStyle()).generateFolder(folderId, settings).blob().filesToAdd();
        Seq requestedFile = (Seq)allFiles.filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$generateUnversionedPreview$1(settings, fileName, file)));
        if (requestedFile.isEmpty()) {
            throw new NotFoundException("Invalid file '" + fileName + "' requested.", new Object[0]);
        }
        return (BinaryFile)requestedFile.head();
    }

    private String[] getFilesForCheckout(String fileName, FolderVersioningSettings config) {
        String scmPath = config.scmPath();
        if (fileName.equals(FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())) {
            return (String[])((Object[])new String[]{FolderVersioningSettings$.MODULE$.getDefinitionsPath(scmPath, fileName)});
        }
        return (String[])((Object[])new String[]{FolderVersioningSettings$.MODULE$.getDefinitionsPath(scmPath, fileName), FolderVersioningSettings$.MODULE$.getDefinitionsPath(scmPath, FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())});
    }

    public void verifyRequestedFile(String fileName, FolderVersioningSettings config, AsCodeJGitConnector scm, String version) {
        Seq<String> imports = this.importsCrawler.findAllImports(config.scmPath(), scm, version);
        if (!imports.contains((Object)fileName)) {
            throw new ScmException("The requested file '" + fileName + "' is not amongst the imports. Available imports are: " + imports.mkString(", ") + ".", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    public BinaryFile getRequestedFile(ScmBlobs checkedOut, String fileName) {
        return (BinaryFile)checkedOut.filesToAdd().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$getRequestedFile$1(fileName, x$1))).get();
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)$this.folderVersioningConfigService.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("Folder Git versioning configuration is not defined for this folder.", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public static final /* synthetic */ boolean $anonfun$generateUnversionedPreview$1(FolderVersioningSettings settings$1, String fileName$3, BinaryFile file) {
        return file.absolutePath().substring(settings$1.scmPath().length() + 1).equals(fileName$3);
    }

    public static final /* synthetic */ boolean $anonfun$getRequestedFile$1(String fileName$4, BinaryFile x$1) {
        return x$1.absolutePath().equals(fileName$4);
    }

    @Autowired
    public FolderVersioningPreviewService(AsCodeJGitConnectorInitializer connectorInitializer, FolderVersioningConfigService folderVersioningConfigService, VersioningStrategyResolver versioningStyleResolver, ImportCrawler importsCrawler) {
        this.connectorInitializer = connectorInitializer;
        this.folderVersioningConfigService = folderVersioningConfigService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.importsCrawler = importsCrawler;
    }
}

