/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.scm.connector.Repository;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import java.io.Serializable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\t\r%\u0003\u0001\u0015!\u0003>\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u00151\b\u0001\"\u0001x\u0005u1u\u000e\u001c3feZ+'o]5p]&twmQ8oM&<7+\u001a:wS\u000e,'BA\b\u0011\u0003\r\u00198-\u001c\u0006\u0003#I\ta!Y:d_\u0012,'BA\n\u0015\u0003)1XM]:j_:Lgn\u001a\u0006\u0003+Y\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005]A\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0012aA2p[\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u0006Y1-[%e'\u0016\u0014h/[2f!\t!s%D\u0001&\u0015\t1C#A\u0004tKJ4\u0018nY3\n\u0005!*#aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\u0006\f\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\fAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0007C\u0001\u00133\u0013\t\u0019TE\u0001\u000bD_:4\u0017nZ;sCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tYB\u0014H\u000f\t\u0003o\u0001i\u0011A\u0004\u0005\u0006E\u0011\u0001\ra\t\u0005\u0006S\u0011\u0001\rA\u000b\u0005\u0006a\u0011\u0001\r!M\u0001\u0007G&$\u0016\u0010]3\u0016\u0003u\u0002\"AP$\u000e\u0003}R!\u0001Q!\u0002\u000fI,g\r\\3di*\u0011!iQ\u0001\u0004CBL'B\u0001#F\u0003\u0019\u0001H.^4j]*\u0011aIF\u0001\tI\u0016\u0004Hn\\=ji&\u0011\u0001j\u0010\u0002\u0005)f\u0004X-A\u0004dSRK\b/\u001a\u0011\u0002-\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKN+G\u000f^5oON$\"\u0001\u0014+\u0011\u00055\u0013V\"\u0001(\u000b\u0005Ey%BA\nQ\u0015\t\tF#\u0001\u0004e_6\f\u0017N\\\u0005\u0003':\u0013\u0001DR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKR$\u0018N\\4t\u0011\u0015)v\u00011\u0001M\u0003%qWm^\"p]\u001aLw-\u0001\beK2,G/Z*fiRLgnZ:\u0015\u0005a[\u0006CA\u000fZ\u0013\tQfD\u0001\u0003V]&$\b\"\u0002/\t\u0001\u0004i\u0016\u0001\u00034pY\u0012,'/\u00133\u0011\u0005y+gBA0d!\t\u0001g$D\u0001b\u0015\t\u0011'$\u0001\u0004=e>|GOP\u0005\u0003Iz\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AMH\u0001\rM&tGmU3ui&twm\u001d\u000b\u0003U6\u00042!H6M\u0013\tagD\u0001\u0004PaRLwN\u001c\u0005\u00069&\u0001\r!X\u0001\u0017M&tGmU3ui&twm\u001d\"z\u0007>tg-[4JIR\u0011A\n\u001d\u0005\u0006c*\u0001\r!X\u0001\tG>tg-[4JI\u00061R\u000f\u001d3bi\u0016\u001cV\r\u001e;j]\u001e\u001cH)\u001b:fGRd\u0017\u0010\u0006\u0002Mi\")Qo\u0003a\u0001\u0019\u000611m\u001c8gS\u001e\f!C^1mS\u0012\fG/Z\"p]\u001aLw\rR1uCR\u0019\u0001\f_=\t\u000bUd\u0001\u0019\u0001'\t\u000bid\u0001\u0019A/\u0002\u0017\u0019|G\u000eZ3s)&$H.\u001a\u0015\u0003\u0001q\u00042!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\u0005\r\u0011QA\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006}\n91+\u001a:wS\u000e,\u0007")
public class FolderVersioningConfigService {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationService configurationService;
    private final Type ciType;

    private Type ciType() {
        return this.ciType;
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig) {
        FolderVersioningSettings folderVersioningSettings;
        Option<FolderVersioningSettings> option = this.findSettings(newConfig.getFolderId());
        if (option instanceof Some) {
            Some some = (Some)option;
            FolderVersioningSettings existingConfig = (FolderVersioningSettings)((Object)some.value());
            existingConfig.updateWith(newConfig);
            folderVersioningSettings = existingConfig;
        } else if (None$.MODULE$.equals(option)) {
            newConfig.setId(this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_ID_ROOT()));
            folderVersioningSettings = newConfig;
        } else {
            throw new MatchError(option);
        }
        FolderVersioningSettings config = folderVersioningSettings;
        this.configurationService.createOrUpdate((BaseConfiguration)config);
        return config;
    }

    public void deleteSettings(String folderId) {
        Option<FolderVersioningSettings> option = this.findSettings(folderId);
        if (option instanceof Some) {
            Some some = (Some)option;
            FolderVersioningSettings config = (FolderVersioningSettings)((Object)some.value());
            this.configurationService.delete(config.getId());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption();
    }

    public FolderVersioningSettings findSettingsByConfigId(String configId) {
        Repository gitConnection = (Repository)this.configurationRepository.find(configId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("Configuration with id " + configId + " not found", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        });
        FolderVersioningSettings folderVersioningSettings = new FolderVersioningSettings();
        folderVersioningSettings.gitConnection_$eq(gitConnection);
        return folderVersioningSettings;
    }

    public FolderVersioningSettings updateSettingsDirectly(FolderVersioningSettings config) {
        return (FolderVersioningSettings)this.configurationRepository.update((BaseConfiguration)config);
    }

    public void validateConfigData(FolderVersioningSettings config, String folderTitle) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)config.scmPath()), (String)("Failed to create folder Git versioning configuration for folder " + folderTitle + ". Repository path cannot be empty."), (Object[])new Object[0]);
    }

    public FolderVersioningConfigService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ConfigurationService configurationService) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

