package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.domain.ReleaseKind
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.{FolderService, ReleaseService}
import org.springframework.stereotype.Component

@Component
class WorkflowAsCodeGenerator(override val folderService: FolderService,
                              override val releaseService: ReleaseService,
                              override val permissions: PermissionChecker)
  extends BaseTemplateAsCodeGenerator {

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateWorkflows
  }

  override protected def getSupportedReleaseKind(): ReleaseKind = ReleaseKind.WORKFLOW
}
