package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter
import com.xebialabs.xlrelease.domain.utils.ScmException
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettingsUtil.{FOLDER_VERSIONING_YAML_FILENAME, getDefinitionsPath}
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings
import com.xebialabs.xlrelease.scm.connector.{BinaryFile, ScmBlobs}
import com.xebialabs.xlrelease.versioning.ascode.scm.DefinitionsGenerator
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.SingleFileStrategy.{SINGLE_FILE, SINGLE_FILE_VALUE}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.io.ByteArrayOutputStream

object SingleFileStrategy {
  val SINGLE_FILE = "singleFile"
  val SINGLE_FILE_VALUE = "Single file"
}

/**
 * Single file for the folder. The file will contain all definitions contained in child folders as well.
 */
@Component
class SingleFileStrategy @Autowired()(definitionsGenerator: DefinitionsGenerator) extends VersioningStyleStrategy {

  override def generateFolder(folderId: String, config: FolderVersioningSettings): FolderContent = {
    try {
      val definitions = definitionsGenerator.generate(folderId, config)

      val stream = new ByteArrayOutputStream()
      val generateCtxs = XLRDefinitionWriter().writeYaml(stream, WriterConfig(definitions, writeSecrets = false, writeDefaults = false))
      val secrets = generateCtxs.flatMap(_.secrets).toMap

      FolderContent(
        ScmBlobs(Seq(BinaryFile(getDefinitionsPath(config.getScmPath), () => stream.toByteArray))),
        definitions,
        secrets
      )
    } catch {
      case e: AsCodeException => throw ScmException(e.getMessage, e.getCause)
    }
  }

  override def getVersionableFileNames(folderId: String, settings: FolderVersioningSettings): List[String] = List(FOLDER_VERSIONING_YAML_FILENAME)

  override def name: String = SINGLE_FILE

  override def value: String = SINGLE_FILE_VALUE

  override def order: Integer = 30
}
