/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.utils.ScmException$;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettingsUtil;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningConfigService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService$;
import com.xebialabs.xlrelease.versioning.ascode.scm.ImportCrawler;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnectorInitializer;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\t\u0013\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dI\u0007!%A\u0005\u0002)DQa\u0015\u0001\u0005\u0002QDq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002D\u0001!I!!\u0012\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u0011Q\n\u0001\u0005\n\u0005U\u0003bBA/\u0001\u0011%\u0011q\f\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!a,\u0001\t\u0003\t\tL\u0001\u0010G_2$WM\u001d,feNLwN\\5oOB\u0013XM^5foN+'O^5dK*\u00111\u0003F\u0001\u0004g\u000el'BA\u000b\u0017\u0003\u0019\t7oY8eK*\u0011q\u0003G\u0001\u000bm\u0016\u00148/[8oS:<'BA\r\u001b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002)\r|gN\\3di>\u0014\u0018J\\5uS\u0006d\u0017N_3s!\tA3&D\u0001*\u0015\tQ##A\u0005d_:tWm\u0019;pe&\u0011A&\u000b\u0002\u001f\u0003N\u001cu\u000eZ3K\u000f&$8i\u001c8oK\u000e$xN]%oSRL\u0017\r\\5{KJ\fQDZ8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4D_:4\u0017nZ*feZL7-\u001a\t\u0003_Aj\u0011AE\u0005\u0003cI\u0011QDR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4D_:4\u0017nZ*feZL7-Z\u0001\u0018m\u0016\u00148/[8oS:<7\u000b^=mKJ+7o\u001c7wKJ\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\n\u0002\u0011M$(/\u0019;fOfL!\u0001O\u001b\u00035Y+'o]5p]&twm\u0015;sCR,w-\u001f*fg>dg/\u001a:\u0002\u001d%l\u0007o\u001c:ug\u000e\u0013\u0018m\u001e7feB\u0011qfO\u0005\u0003yI\u0011Q\"S7q_J$8I]1xY\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003@\u0001\u0006\u00135\t\u0005\u00020\u0001!)a%\u0002a\u0001O!)Q&\u0002a\u0001]!)!'\u0002a\u0001g!)\u0011(\u0002a\u0001u!\u0012Q!\u0012\t\u0003\rFk\u0011a\u0012\u0006\u0003\u0011&\u000b!\"\u00198o_R\fG/[8o\u0015\tQ5*A\u0004gC\u000e$xN]=\u000b\u00051k\u0015!\u00022fC:\u001c(B\u0001(P\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u000f\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0010O\u0016tWM]1uKB\u0013XM^5foR!Q\u000b\u00192h!\t1VL\u0004\u0002X7B\u0011\u0001LI\u0007\u00023*\u0011!LH\u0001\u0007yI|w\u000e\u001e \n\u0005q\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001\u0018\u0012\t\u000b\u00054\u0001\u0019A+\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012DQa\u0019\u0004A\u0002\u0011\fqA^3sg&|g\u000eE\u0002\"KVK!A\u001a\u0012\u0003\r=\u0003H/[8o\u0011\u001dAg\u0001%AA\u0002U\u000b\u0001BZ5mK:\u000bW.Z\u0001\u001aO\u0016tWM]1uKB\u0013XM^5fo\u0012\"WMZ1vYR$3'F\u0001lU\t)FnK\u0001n!\tq'/D\u0001p\u0015\t\u0001\u0018/A\u0005v]\u000eDWmY6fI*\u0011\u0001JI\u0005\u0003g>\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u0011)\b0\u001f>\u0011\tY3X+V\u0005\u0003o~\u00131!T1q\u0011\u0015\t\u0007\u00021\u0001V\u0011\u0015\u0019\u0007\u00021\u0001e\u0011\u0015Y\b\u00021\u0001}\u0003%1\u0017\u000e\\3oC6,7\u000f\u0005\u0003~\u0003\u000b)fb\u0001@\u0002\u00029\u0011\u0001l`\u0005\u0002G%\u0019\u00111\u0001\u0012\u0002\u000fA\f7m[1hK&!\u0011qAA\u0005\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r!%\u0001\fhK:,'/\u0019;f-\u0016\u00148/[8o!J,g/[3x))\ty!a\u0007\u0002\u001e\u0005U\u0012q\b\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019!&!\u0006\u000b\u0005MA\u0012\u0002BA\r\u0003'\u0011!BQ5oCJLh)\u001b7f\u0011\u0015A\u0017\u00021\u0001V\u0011\u001d\ty\"\u0003a\u0001\u0003C\taaY8oM&<\u0007\u0003BA\u0012\u0003ci!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\tg\u0016$H/\u001b8hg*\u0019Q#a\u000b\u000b\u0007]\tiCC\u0002\u00020a\ta\u0001Z8nC&t\u0017\u0002BA\u001a\u0003K\u0011\u0001DR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKR$\u0018N\\4t\u0011\u001d\t9$\u0003a\u0001\u0003s\tqBZ5mKN$vn\u00115fG.|W\u000f\u001e\t\u0005C\u0005mR+C\u0002\u0002>\t\u0012Q!\u0011:sCfDa!!\u0011\n\u0001\u0004)\u0016a\u0001<fe\u0006Qr-\u001a8fe\u0006$X-\u00168wKJ\u001c\u0018n\u001c8fIB\u0013XM^5foRA\u0011qBA$\u0003\u0013\nY\u0005C\u0003b\u0015\u0001\u0007Q\u000bC\u0003i\u0015\u0001\u0007Q\u000bC\u0004\u0002()\u0001\r!!\t\u0002'\u001d,GOR5mKN4uN]\"iK\u000e\\w.\u001e;\u0015\r\u0005e\u0012\u0011KA*\u0011\u0015A7\u00021\u0001V\u0011\u001d\tyb\u0003a\u0001\u0003C!b!!\u000f\u0002X\u0005m\u0003BBA-\u0019\u0001\u0007A0A\u0005gS2,g*Y7fg\"9\u0011q\u0004\u0007A\u0002\u0005\u0005\u0012AE3yiJ\f7\r\u001e$jY\u0016\u001cuN\u001c;f]R$\u0002\"!\u0019\u0002~\u0005}\u0014\u0011\u0012\t\t\u0003G\ni'a\u001c\u0002p5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0005j[6,H/\u00192mK*\u0019\u00111\u000e\u0012\u0002\u0015\r|G\u000e\\3di&|g.C\u0002x\u0003K\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003mC:<'BAA=\u0003\u0011Q\u0017M^1\n\u0007y\u000b\u0019\bC\u0004\u000285\u0001\r!!\u000f\t\u000f\u0005\u0005U\u00021\u0001\u0002\u0004\u000691oY7CY>\u0014\u0007\u0003BA\t\u0003\u000bKA!a\"\u0002\u0014\tA1kY7CY>\u00147\u000f\u0003\u0004\u0002\f6\u0001\r!V\u0001\bg\u000el\u0007+\u0019;i\u0003M1XM]5gsJ+\u0017/^3ti\u0016$g)\u001b7f))\t\t*a&\u0002\u001a\u0006m\u00151\u0015\t\u0004C\u0005M\u0015bAAKE\t!QK\\5u\u0011\u0015Ag\u00021\u0001V\u0011\u001d\tyB\u0004a\u0001\u0003CAaa\u0005\bA\u0002\u0005u\u0005c\u0001\u0015\u0002 &\u0019\u0011\u0011U\u0015\u0003'\u0005\u001b8i\u001c3f\u0015\u001eKGoQ8o]\u0016\u001cGo\u001c:\t\u000b\rt\u0001\u0019A+\u0002!\u001d,GOU3rk\u0016\u001cH/\u001a3GS2,GCBA\b\u0003S\u000bi\u000bC\u0004\u0002,>\u0001\r!a!\u0002\u0015\rDWmY6fI>+H\u000fC\u0003i\u001f\u0001\u0007Q+A\u0006hKR\u001cV\r\u001e;j]\u001e\u001cH\u0003BA\u0011\u0003gCQ!\u0019\tA\u0002UC3\u0001AA\\!\u0011\tI,a0\u000e\u0005\u0005m&bAA_\u001b\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u0005\u00171\u0018\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class FolderVersioningPreviewService {
    private final AsCodeJGitConnectorInitializer connectorInitializer;
    private final FolderVersioningConfigService folderVersioningConfigService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final ImportCrawler importsCrawler;

    public String generatePreview(String folderId, Option<String> version, String fileName) {
        return (String)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> {
            BinaryFile binaryFile;
            FolderVersioningSettings config = this.getSettings(folderId);
            String finalFileName = fileName.isEmpty() ? "Releasefile.yaml" : fileName;
            String[] filesToCheckout = this.getFilesForCheckout(finalFileName, config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                binaryFile = this.generateVersionPreview(finalFileName, config, filesToCheckout, ver);
            } else if (None$.MODULE$.equals(option)) {
                binaryFile = this.generateUnversionedPreview(folderId, finalFileName, config);
            } else {
                throw new MatchError((Object)option);
            }
            BinaryFile blobs = binaryFile;
            return new String((byte[])blobs.getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public Map<String, String> generatePreview(String folderId, Option<String> version, List<String> filenames) {
        return (Map)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> {
            FolderVersioningSettings config = this.getSettings(folderId);
            String[] filesToCheckout = this.getFilesForCheckout(filenames, config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                return (Map)Using$.MODULE$.resource((Object)$this.connectorInitializer.init(config), (Function1 & Serializable)scmConnector -> {
                    boolean bl = false;
                    Failure failure = null;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> scmConnector.checkout(filesToCheckout, ver, false));
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        ScmBlobs scmBlob = (ScmBlobs)success.value();
                        return this.extractFileContent(filesToCheckout, scmBlob, config.getScmPath());
                    }
                    if (try_ instanceof Failure) {
                        ScmException scmException;
                        bl = true;
                        failure = (Failure)try_;
                        Throwable ex = failure.exception();
                        if (ex instanceof ScmException && (scmException = (ScmException)ex).getMessage().contains("No definition file found for tag")) {
                            throw new NotFoundException(scmException.getMessage(), new Object[0]);
                        }
                    }
                    if (bl) {
                        Throwable ex = failure.exception();
                        throw ex;
                    }
                    throw new MatchError((Object)try_);
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            }
            if (None$.MODULE$.equals(option)) {
                ScmBlobs scmBlob = $this.versioningStyleResolver.resolve(config.getVersioningStyle()).generateFolder(folderId, config).blob();
                return this.extractFileContent(filesToCheckout, scmBlob, config.getScmPath());
            }
            throw new MatchError((Object)option);
        });
    }

    public String generatePreview$default$3() {
        return "Releasefile.yaml";
    }

    private BinaryFile generateVersionPreview(String fileName, FolderVersioningSettings config, String[] filesToCheckout, String ver) {
        String filenameWithPath = FolderVersioningSettingsUtil.getDefinitionsPath((String)config.getScmPath(), (String)fileName);
        return (BinaryFile)Using$.MODULE$.resource((Object)this.connectorInitializer.init(config), (Function1 & Serializable)scmConnector -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> scmConnector.checkout(filesToCheckout, ver, false));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ScmBlobs checkedOut = (ScmBlobs)success.value();
                if (!fileName.equals("Releasefile.yaml")) {
                    this.verifyRequestedFile(fileName, config, (AsCodeJGitConnector)scmConnector, ver);
                }
                return this.getRequestedFile(checkedOut, filenameWithPath);
            }
            if (try_ instanceof Failure) {
                ScmException scmException;
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (ex instanceof ScmException && (scmException = (ScmException)ex).getMessage().contains("No definition file found for tag")) {
                    throw new NotFoundException(scmException.getMessage(), new Object[0]);
                }
            }
            if (bl) {
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError((Object)try_);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private BinaryFile generateUnversionedPreview(String folderId, String fileName, FolderVersioningSettings settings) {
        Seq allFiles = this.versioningStyleResolver.resolve(settings.getVersioningStyle()).generateFolder(folderId, settings).blob().filesToAdd();
        Seq requestedFile = (Seq)allFiles.filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$generateUnversionedPreview$1(settings, fileName, file)));
        if (requestedFile.isEmpty()) {
            throw new NotFoundException("Invalid file '" + fileName + "' requested.", new Object[0]);
        }
        return (BinaryFile)requestedFile.head();
    }

    private String[] getFilesForCheckout(String fileName, FolderVersioningSettings config) {
        String scmPath = config.getScmPath();
        if (fileName.equals("Releasefile.yaml")) {
            return (String[])((Object[])new String[]{FolderVersioningSettingsUtil.getDefinitionsPath((String)scmPath, (String)fileName)});
        }
        return (String[])((Object[])new String[]{FolderVersioningSettingsUtil.getDefinitionsPath((String)scmPath, (String)fileName), FolderVersioningSettingsUtil.getDefinitionsPath((String)scmPath, (String)"Releasefile.yaml")});
    }

    private String[] getFilesForCheckout(List<String> fileNames, FolderVersioningSettings config) {
        return (String[])fileNames.flatMap((Function1 & Serializable)entry -> new .colon.colon((Object)FolderVersioningSettingsUtil.getDefinitionsPath((String)config.getScmPath(), (String)entry), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private Map<String, String> extractFileContent(String[] filesToCheckout, ScmBlobs scmBlob, String scmPath) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])filesToCheckout), (Function1 & Serializable)fileName -> {
            BinaryFile content = this.getRequestedFile(scmBlob, (String)fileName);
            String key = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(fileName), scmPath + "/");
            String value = new String((byte[])content.getContent().apply(), StandardCharsets.UTF_8);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void verifyRequestedFile(String fileName, FolderVersioningSettings config, AsCodeJGitConnector scm, String version) {
        Seq<String> imports = this.importsCrawler.findAllImports(config.getScmPath(), scm, version);
        if (!imports.contains((Object)fileName)) {
            throw new ScmException("The requested file '" + fileName + "' is not amongst the imports. Available imports are: " + imports.mkString(", ") + ".", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    public BinaryFile getRequestedFile(ScmBlobs checkedOut, String fileName) {
        return (BinaryFile)checkedOut.filesToAdd().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$getRequestedFile$1(fileName, x$1))).get();
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)$this.folderVersioningConfigService.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("Folder Git versioning configuration is not defined for this folder.", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }));
    }

    public static final /* synthetic */ boolean $anonfun$generateUnversionedPreview$1(FolderVersioningSettings settings$1, String fileName$3, BinaryFile file) {
        return file.absolutePath().substring(settings$1.getScmPath().length() + 1).equals(fileName$3);
    }

    public static final /* synthetic */ boolean $anonfun$getRequestedFile$1(String fileName$4, BinaryFile x$1) {
        return x$1.absolutePath().equals(fileName$4);
    }

    @Autowired
    public FolderVersioningPreviewService(AsCodeJGitConnectorInitializer connectorInitializer, FolderVersioningConfigService folderVersioningConfigService, VersioningStrategyResolver versioningStyleResolver, ImportCrawler importsCrawler) {
        this.connectorInitializer = connectorInitializer;
        this.folderVersioningConfigService = folderVersioningConfigService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.importsCrawler = importsCrawler;
    }
}

