package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.parser.SpecParser

import scala.jdk.CollectionConverters._

object ApplicationsSpecAdapter extends SpecParser {

  override def parse(definitionKind: String, metadata: Option[Map[String, String]], node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    if (!node.elements().asScala.forall(_.has("directory")) && node.elements().asScala.forall(!_.has("type"))) {
      ApplicationsSpecParser.parse(definitionKind, metadata, node)
    } else {
      CiParser.parse(definitionKind, metadata, node)
    }
  }
}
