package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.xlrelease.api.v1.EnvironmentStageApi
import com.xebialabs.xlrelease.ascode.utils.ImportContext
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage
import com.xebialabs.xlrelease.environments.repository.EnvironmentStageRepository
import org.springframework.stereotype.Service

@Service
class EnvironmentStageAsCodeService(environmentStageApi: EnvironmentStageApi,
                                    environmentStageRepository: EnvironmentStageRepository) {

  def process(context: ImportContext, environmentStage: EnvironmentStage): ImportResult = {
    try {
      val existing = environmentStageRepository.findByTitle(environmentStage.getTitle)
      update(context, environmentStage, existing)
    } catch {
      case _: NotFoundException =>
        create(context, environmentStage)
    }
  }

  private def create(context: ImportContext, environmentStage: EnvironmentStage) = {
    val messages = validate(context, environmentStage)
    val created = environmentStageApi.create(environmentStage)
    ImportResult(List(CI.ids.withCreated(created.getId)),
      Seq.empty,
      Map.empty,
      messages
    )
  }

  private def update(context: ImportContext, environmentStage: EnvironmentStage, existing: EnvironmentStage) = {
    environmentStage.setId(existing.getId)
    val messages = validate(context, environmentStage)
    val updated = environmentStageApi.update(environmentStage)
    ImportResult(List(CI.ids.withUpdated(updated.getId)),
      Seq.empty,
      Map.empty,
      messages
    )
  }

  private def validate(context: ImportContext, environmentStage: EnvironmentStage): List[ValidationMessage] = {
    context.validator match {
      case Some(validator) => validator.validateCi(environmentStage, context.getFolderInfo()).toList
      case None => List.empty
    }
  }

}
