/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.FolderVersioningApi;
import com.xebialabs.xlrelease.api.v1.form.CreateVersionForm;
import com.xebialabs.xlrelease.api.v1.views.VersionComparisonView;
import com.xebialabs.xlrelease.api.v1.views.VersionInfo;
import com.xebialabs.xlrelease.api.v1.views.VersionsView;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.versioning.ascode.FoldersWithAppliedVersionInfo;
import com.xebialabs.xlrelease.domain.versioning.ascode.GitBranch;
import com.xebialabs.xlrelease.domain.versioning.ascode.VersioningStyle;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReport;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import java.util.Date;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t%g\u0001\u0002\u0015*\u0001YB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u00119\u0004!\u0011!Q\u0001\n=DQA\u001d\u0001\u0005\u0002MDQ! \u0001\u0005ByDa! \u0001\u0005B\u0005M\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003;\u0002A\u0011IA0\u0011\u001d\ti\u0006\u0001C!\u0003sBq!!\"\u0001\t\u0003\n9\tC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011q\u0016\u0001\u0005B\u0005E\u0006bBA]\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!a>\u0001\t\u0003\nI\u0010C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\u0012!9!Q\u0003\u0001\u0005B\t]\u0001b\u0002B\u000f\u0001\u0011\u0005#q\u0004\u0005\b\u0005G\u0001A\u0011\tB\u0013\u0011\u001d\u0011I\u0003\u0001C!\u0005WAqAa\r\u0001\t\u0003\u0012)\u0004C\u0004\u0003D\u0001!\tE!\u0012\t\u000f\t=\u0003\u0001\"\u0011\u0003R!9!Q\u000b\u0001\u0005B\t]\u0003b\u0002B1\u0001\u0011\u0005#1\r\u0005\b\u0005g\u0002A\u0011\tB;\u0011\u001d\u0011i\b\u0001C!\u0005\u007fBqA!$\u0001\t\u0003\u0012y\tC\u0004\u0003\u0016\u0002!\tEa&\t\u000f\t\u0005\u0006\u0001\"\u0003\u0003$\"9!q\u0015\u0001\u0005\n\t%\u0006b\u0002BW\u0001\u0011%!q\u0016\u0002\u0018\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\f\u0005/[%na2T!AK\u0016\u0002\t%l\u0007\u000f\u001c\u0006\u0003Y5\n!A^\u0019\u000b\u00059z\u0013aA1qS*\u0011\u0001'M\u0001\nq2\u0014X\r\\3bg\u0016T!AM\u001a\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u001b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019t\b\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!A.\u00198h\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001d\u0003\r=\u0013'.Z2u!\t\u0001\u0015)D\u0001,\u0013\t\u00115FA\nG_2$WM\u001d,feNLwN\\5oO\u0006\u0003\u0018.A\tqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u0018\u0002\u0011M,7-\u001e:jifL!!\u0013$\u0003#A+'/\\5tg&|gn\u00115fG.,'/A\fg_2$WM\u001d,feNLwN\\5oON+'O^5dKB\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0004g\u000el'B\u0001)R\u0003\u0019\t7oY8eK*\u0011!kL\u0001\u000bm\u0016\u00148/[8oS:<\u0017B\u0001+N\u0005]1u\u000e\u001c3feZ+'o]5p]&twmU3sm&\u001cW-\u0001\bqe\u00164\u0018.Z<TKJ4\u0018nY3\u0011\u00051;\u0016B\u0001-N\u0005y1u\u000e\u001c3feZ+'o]5p]&tw\r\u0015:fm&,woU3sm&\u001cW-\u0001\u000fg_2$WM\u001d,feNLwN\\5oO\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005msV\"\u0001/\u000b\u0005u{\u0015AB1di>\u00148/\u0003\u0002`9\nabi\u001c7eKJ4VM]:j_:LgnZ!di>\u00148+\u001a:wS\u000e,\u0017a\u0006<feNLwN\\5oON#\u0018\u0010\\3SKN|GN^3s!\t\u0011W-D\u0001d\u0015\t!W*\u0001\u0005tiJ\fG/Z4z\u0013\t17M\u0001\u000eWKJ\u001c\u0018n\u001c8j]\u001e\u001cFO]1uK\u001eL(+Z:pYZ,'/\u0001\u000bd_:4\u0017nZ;sCRLwN\\*feZL7-\u001a\t\u0003S2l\u0011A\u001b\u0006\u0003W>\nqa]3sm&\u001cW-\u0003\u0002nU\n!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\fQBZ8mI\u0016\u00148+\u001a:wS\u000e,\u0007CA5q\u0013\t\t(NA\u0007G_2$WM]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011Q4x\u000f_={wr\u0004\"!\u001e\u0001\u000e\u0003%BQa\u0011\u0005A\u0002\u0011CQA\u0013\u0005A\u0002-CQ!\u0016\u0005A\u0002YCQ!\u0017\u0005A\u0002iCQ\u0001\u0019\u0005A\u0002\u0005DQa\u001a\u0005A\u0002!DQA\u001c\u0005A\u0002=\f1bZ3u-\u0016\u00148/[8ogR)q0a\u0003\u0002*A!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006-\nQA^5foNLA!!\u0003\u0002\u0004\taa+\u001a:tS>t7OV5fo\"9\u0011QB\u0005A\u0002\u0005=\u0011\u0001\u00034pY\u0012,'/\u00133\u0011\t\u0005E\u00111\u0005\b\u0005\u0003'\ty\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"N\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005u\u0011!B:dC2\f\u0017\u0002BA\u0011\u00037\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'\u0002BA\u0011\u00037Aq!a\u000b\n\u0001\u0004\ti#\u0001\u0007gKR\u001c\u0007n\u00115b]\u001e,7\u000fE\u00029\u0003_I1!!\r:\u0005\u001d\u0011un\u001c7fC:$2a`A\u001b\u0011\u001d\tiA\u0003a\u0001\u0003\u001f\tabZ3u\u00032d'I]1oG\",7\u000f\u0006\u0004\u0002<\u0005]\u0013\u0011\f\t\u0007\u0003{\t\u0019%a\u0012\u000e\u0005\u0005}\"bAA!w\u0005!Q\u000f^5m\u0013\u0011\t)%a\u0010\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)\u0019\u0001+!\u0014\u000b\u0007I\u000byEC\u0002\u0002R=\na\u0001Z8nC&t\u0017\u0002BA+\u0003\u0017\u0012\u0011bR5u\u0005J\fgn\u00195\t\u000f\u000551\u00021\u0001\u0002\u0010!9\u00111L\u0006A\u0002\u0005=\u0011\u0001C2p]\u001aLw-\u00133\u0002\u001b\r\u0014X-\u0019;f-\u0016\u00148/[8o)\u0019\t\t'a\u001a\u0002jA!\u0011\u0011AA2\u0013\u0011\t)'a\u0001\u0003\u0017Y+'o]5p]&sgm\u001c\u0005\b\u0003\u001ba\u0001\u0019AA\b\u0011\u001d\tY\u0007\u0004a\u0001\u0003[\n1B^3sg&|gNR8s[B!\u0011qNA;\u001b\t\t\tHC\u0002\u0002t-\nAAZ8s[&!\u0011qOA9\u0005E\u0019%/Z1uKZ+'o]5p]\u001a{'/\u001c\u000b\t\u0003C\nY(! \u0002\u0002\"9\u0011QB\u0007A\u0002\u0005=\u0001bBA@\u001b\u0001\u0007\u0011qB\u0001\fm\u0016\u00148/[8o\u001d\u0006lW\rC\u0004\u0002\u00046\u0001\r!a\u0004\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0001\rCB\u0004H.\u001f,feNLwN\u001c\u000b\u0007\u0003\u0013\u000b)*a&\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bSA!a$\u0002L\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\u0011-\u0006d\u0017\u000eZ1uS>t'+\u001a9peRDq!!\u0004\u000f\u0001\u0004\ty\u0001C\u0004\u0002\u001a:\u0001\r!a\u0004\u0002\u000fY,'o]5p]\u0006q\u0001O]3wS\u0016<8)\u001e:sK:$HCBA\b\u0003?\u000b\t\u000bC\u0004\u0002\u000e=\u0001\r!a\u0004\t\u000f\u0005\rv\u00021\u0001\u0002\u0010\u0005Aa-\u001b7f]\u0006lW-\u0001\bqe\u00164\u0018.Z<WKJ\u001c\u0018n\u001c8\u0015\u0011\u0005=\u0011\u0011VAV\u0003[Cq!!\u0004\u0011\u0001\u0004\ty\u0001C\u0004\u0002\u001aB\u0001\r!a\u0004\t\u000f\u0005\r\u0006\u00031\u0001\u0002\u0010\u0005)r-\u001a;WKJ\u001c\u0018n\u001c8fI\u001aKG.\u001a(b[\u0016\u001cHCBAZ\u0003k\u000b9\f\u0005\u0004\u0002>\u0005\r\u0013q\u0002\u0005\b\u0003\u001b\t\u0002\u0019AA\b\u0011\u001d\tI*\u0005a\u0001\u0003\u001f\tadZ3u\u0007V\u0014(/\u001a8u-\u0016\u00148/[8oC\ndWMR5mK:\u000bW.Z:\u0015\t\u0005M\u0016Q\u0018\u0005\b\u0003\u001b\u0011\u0002\u0019AA\b\u0003-9W\r^*fiRLgnZ:\u0015\t\u0005\r\u0017q\u001a\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*!\u0011\u0011ZA&\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018\u0002BAg\u0003\u000f\u0014\u0001DR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4TKR$\u0018N\\4t\u0011\u001d\tia\u0005a\u0001\u0003\u001fA\u0003\"a4\u0002T\u0006\u001d\u0018\u0011\u001e\t\u0005\u0003+\f\u0019/\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\t\u00118O\u0003\u0003\u0002^\u0006}\u0017AA<t\u0015\t\t\t/A\u0004kC.\f'\u000f^1\n\t\u0005\u0015\u0018q\u001b\u0002\n!\u0006$\b\u000eU1sC6\fQA^1mk\u0016\f#!!\u0004\u0002\u001dU\u0004H-\u0019;f'\u0016$H/\u001b8hgR1\u00111YAx\u0003gDq!!\u0004\u0015\u0001\u0004\ty\u0001\u000b\u0005\u0002p\u0006M\u0017q]Au\u0011\u001d\t)\u0010\u0006a\u0001\u0003\u0007\faaY8oM&<\u0017A\u00043fY\u0016$XmU3ui&twm\u001d\u000b\u0005\u0003w\u0014\u0019\u0001\u0005\u0003\u0002~\u0006}XBAA\u000e\u0013\u0011\u0011\t!a\u0007\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001b)\u0002\u0019AA\bQ!\u0011\u0019!a5\u0002h\u0006%\u0018a\u00043fY\u0016$X\rT8dC2\u0014V\r]8\u0015\r\u0005m(1\u0002B\u0007\u0011\u001d\tiA\u0006a\u0001\u0003\u001fAqAa\u0004\u0017\u0001\u0004\ti#A\u0006dYV\u001cH/\u001a:XS\u0012,G\u0003BA~\u0005'Aq!!\u0004\u0018\u0001\u0004\ty!\u0001\bsKN,G\u000fT8dC2\u0014V\r]8\u0015\r\u0005m(\u0011\u0004B\u000e\u0011\u001d\ti\u0001\u0007a\u0001\u0003\u001fAqAa\u0004\u0019\u0001\u0004\ti#A\bwC2LG-\u0019;f\u0007V\u0014(/\u001a8u)\u0011\tII!\t\t\u000f\u00055\u0011\u00041\u0001\u0002\u0010\u0005)r-\u001a;WC2LG-\u0019;j_:lUm]:bO\u0016\u001cH\u0003BAE\u0005OAq!!\u0004\u001b\u0001\u0004\ty!A\u000btKR4\u0016\r\\5eCRLwN\\'fgN\fw-Z:\u0015\r\u0005m(Q\u0006B\u0018\u0011\u001d\tia\u0007a\u0001\u0003\u001fAqA!\r\u001c\u0001\u0004\tI)\u0001\twC2LG-\u0019;j_:\u0014V\r]8si\u0006!r-\u001a;WC2LG-\u0019;j_:lUm]:bO\u0016$bAa\u000e\u0003>\t}\u0002\u0003BAF\u0005sIAAa\u000f\u0002\u000e\n9b+\u00197jI\u0006$\u0018n\u001c8SKB|'\u000f^'fgN\fw-\u001a\u0005\b\u0003\u001ba\u0002\u0019AA\b\u0011\u001d\u0011\t\u0005\ba\u0001\u0003\u001f\t\u0011\"\\3tg\u0006<W-\u00133\u00027M,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fgN#\u0018\r^;t)!\tYPa\u0012\u0003J\t-\u0003bBA\u0007;\u0001\u0007\u0011q\u0002\u0005\b\u0005\u0003j\u0002\u0019AA\b\u0011\u001d\u0011i%\ba\u0001\u0005o\t\u0011C^1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4f\u00031\u0019G.Z1s'\u0016\u001c'/\u001a;t)\u0011\tYPa\u0015\t\u000f\u00055a\u00041\u0001\u0002\u0010\u0005\u0019r-\u001a;WKJ\u001c\u0018n\u001c8j]\u001e\u001cF/\u001f7fgR\u0011!\u0011\f\t\u0007\u0003{\t\u0019Ea\u0017\u0011\t\u0005%#QL\u0005\u0005\u0005?\nYEA\bWKJ\u001c\u0018n\u001c8j]\u001e\u001cF/\u001f7f\u0003M\u0019w.\u001c9be\u00164\u0015\u000e\\3WKJ\u001c\u0018n\u001c8t))\tyA!\u001a\u0003h\t-$q\u000e\u0005\b\u0003\u001b\u0001\u0003\u0019AA\b\u0011\u001d\u0011I\u0007\ta\u0001\u0003\u001f\t\u0001BZ5mK:\u000bW.\u001a\u0005\b\u0005[\u0002\u0003\u0019AA\b\u0003-aWM\u001a;WKJ\u001c\u0018n\u001c8\t\u000f\tE\u0004\u00051\u0001\u0002\u0010\u0005a!/[4iiZ+'o]5p]\u0006i2m\\7qCJ,g)\u001b7f-\u0016\u00148/[8o/&$\bnQ;se\u0016tG\u000f\u0006\u0005\u0002\u0010\t]$\u0011\u0010B>\u0011\u001d\ti!\ta\u0001\u0003\u001fAqA!\u001b\"\u0001\u0004\ty\u0001C\u0004\u0002\u001a\u0006\u0002\r!a\u0004\u0002\u001f\r|W\u000e]1sKZ+'o]5p]N$\u0002B!!\u0003\b\n%%1\u0012\t\u0005\u0003\u0003\u0011\u0019)\u0003\u0003\u0003\u0006\u0006\r!!\u0006,feNLwN\\\"p[B\f'/[:p]ZKWm\u001e\u0005\b\u0003\u001b\u0011\u0003\u0019AA\b\u0011\u001d\u0011iG\ta\u0001\u0003\u001fAqA!\u001d#\u0001\u0004\ty!A\rd_6\u0004\u0018M]3WKJ\u001c\u0018n\u001c8XSRD7)\u001e:sK:$HC\u0002BA\u0005#\u0013\u0019\nC\u0004\u0002\u000e\r\u0002\r!a\u0004\t\u000f\u0005e5\u00051\u0001\u0002\u0010\u00051r-\u001a;WKJ\u001c\u0018n\u001c8fI\u001a{G\u000eZ3s\u0013:4w\u000e\u0006\u0002\u0003\u001aB1\u0011QHA\"\u00057\u0003B!!\u0013\u0003\u001e&!!qTA&\u0005u1u\u000e\u001c3feN<\u0016\u000e\u001e5BaBd\u0017.\u001a3WKJ\u001c\u0018n\u001c8J]\u001a|\u0017\u0001\t<bY&$\u0017\r^3G_2$WM\u001d,feNLwN\\5oON+G\u000f^5oON$B!a?\u0003&\"9\u0011Q_\u0013A\u0002\u0005\r\u0017a\u0006<bY&$\u0017\r^3WKJ\u001c\u0018n\u001c8j]\u001e\u001cF/\u001f7f)\u0011\tYPa+\t\u000f\u0005Uh\u00051\u0001\u0002D\u0006)b/\u00197jI\u0006$XmR5u\u0007>tg.Z2uS>tG\u0003BA~\u0005cCq!!>(\u0001\u0004\t\u0019\rK\u0002\u0001\u0005k\u0003BAa.\u0003F6\u0011!\u0011\u0018\u0006\u0005\u0005w\u0013i,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TAAa0\u0003B\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0003D\u0006\u0019qN]4\n\t\t\u001d'\u0011\u0018\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class FolderVersioningApiImpl
implements FolderVersioningApi {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final ConfigurationService configurationService;
    private final FolderService folderService;

    public String serviceName() {
        return super.serviceName();
    }

    public VersionsView getVersions(String folderId, Boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = Predef$.MODULE$.Boolean2boolean(fetchChanges) ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    public VersionsView getVersions(String folderId) {
        return this.getVersions(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public java.util.List<GitBranch> getAllBranches(String folderId, String configId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getAllBranches(configId)).asJava();
    }

    public VersionInfo createVersion(String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)versionForm.getName()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (String)"Version name must be provided.", (Object[])new Object[0]);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.getName(), (String)Option$.MODULE$.apply((Object)versionForm.getDescription()).getOrElse((Function0 & Serializable)() -> ""));
    }

    public VersionInfo createVersion(String folderId, String versionName, String description) {
        CreateVersionForm createVersionForm = new CreateVersionForm();
        createVersionForm.setName(versionName);
        createVersionForm.setDescription(description);
        return this.createVersion(folderId, createVersionForm);
    }

    public ValidationReport applyVersion(String folderId, String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        return this.folderVersioningService.applyVersion(folderId, version);
    }

    public String previewCurrent(String folderId, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, (String)Option$.MODULE$.apply((Object)filename).getOrElse((Function0 & Serializable)() -> ""));
    }

    public String previewVersion(String folderId, String version, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    public java.util.List<String> getVersionedFileNames(String folderId, String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionedFileNames(folderId, version)).asJava();
    }

    public java.util.List<String> getCurrentVersionableFileNames(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionableFileNames(folderId)).asJava();
    }

    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        FolderVersioningSettings folderVersioningSettings;
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.validateFolderVersioningSettings(config);
        config.setFolderId(folderId);
        try {
            folderVersioningSettings = this.folderVersioningActorService.createOrUpdateSettings(config);
        }
        catch (ScmException e) {
            throw new IllegalArgumentException("Unable to update folder versioning settings: " + e.getMessage(), e);
        }
        return folderVersioningSettings;
    }

    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.folderService.exists(folderId), (String)("Folder '" + folderId + "' does not exist in the repository."), (Object[])new Object[0]);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    public void deleteLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public void deleteLocalRepo(String folderId) {
        this.deleteLocalRepo(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public void resetLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public ValidationReport validateCurrent(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    public ValidationReport getValidationMessages(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    public void setValidationMessages(String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.getWarnings()).asScala().toSeq());
    }

    public ValidationReportMessage getValidationMessage(String folderId, String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (ValidationReportMessage)Option$.MODULE$.apply((Object)this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Validation message with id " + messageId + " not found");
        });
    }

    public void setValidationMessagesStatus(String folderId, String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    public void clearSecrets(String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    public java.util.List<VersioningStyle> getVersioningStyles() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersioningStyles()).asJava();
    }

    public String compareFileVersions(String folderId, String fileName, String leftVersion, String rightVersion) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Checks.checkArgument((fileName != null && !fileName.isEmpty() ? 1 : 0) != 0, (String)"File name must be provided for comparison.", (Object[])new Object[0]);
        return this.folderVersioningService.compareFileVersions(folderId, fileName, leftVersion, rightVersion);
    }

    public String compareFileVersionWithCurrent(String folderId, String fileName, String version) {
        return this.compareFileVersions(folderId, fileName, version, "");
    }

    public VersionComparisonView compareVersions(String folderId, String leftVersion, String rightVersion) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.compareVersions(folderId, leftVersion, rightVersion);
    }

    public VersionComparisonView compareVersionWithCurrent(String folderId, String version) {
        return this.compareVersions(folderId, version, "");
    }

    public java.util.List<FoldersWithAppliedVersionInfo> getVersionedFolderInfo() {
        return this.folderVersioningService.getVersionedFolderInfo();
    }

    private void validateFolderVersioningSettings(FolderVersioningSettings config) {
        this.validateVersioningStyle(config);
        this.validateGitConnection(config);
    }

    private void validateVersioningStyle(FolderVersioningSettings config) {
        Option styleInput = Option$.MODULE$.apply((Object)config.getVersioningStyle()).map((Function1 & Serializable)x$3 -> x$3.trim());
        boolean bl = false;
        Some some = null;
        Option option = styleInput;
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String style = (String)some.value();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(style))) {
                List<VersioningStyle> supported = this.versioningStyleResolver.supportedStyles();
                String canonical = (String)supported.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningApiImpl.$anonfun$validateVersioningStyle$2(style, s))).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> {
                    String allowed = supported.map((Function1 & Serializable)x$5 -> x$5.id()).mkString(", ");
                    throw new IllegalArgumentException("Invalid versioningStyle '" + style + "'. Supported versioning styles: " + allowed);
                });
                config.setVersioningStyle(canonical);
                return;
            }
        }
        if (bl) {
            String allowed = this.versioningStyleResolver.supportedStyles().map((Function1 & Serializable)x$6 -> x$6.id()).mkString(", ");
            throw new IllegalArgumentException("Missing versioningStyle. Supported versioning styles: " + allowed);
        }
        throw new MatchError((Object)option);
    }

    private void validateGitConnection(FolderVersioningSettings config) {
        boolean gitConnectionValid = Option$.MODULE$.apply((Object)config.getGitConnection()).exists((Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)this.configurationService.exists(conn.getId())));
        Checks.checkArgument((boolean)gitConnectionValid, (String)"A valid gitConnection must be specified.", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$validateVersioningStyle$2(String style$1, VersioningStyle s) {
        return s.id().equalsIgnoreCase(style$1);
    }

    public FolderVersioningApiImpl(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService, VersioningStrategyResolver versioningStyleResolver, ConfigurationService configurationService, FolderService folderService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.configurationService = configurationService;
        this.folderService = folderService;
    }
}

